<?php

namespace App;

// array_map(function ($file) {
//   $file = "../app/gutenberg/{$file}.php";
//   if (!locate_template($file, true, true)) {
//     wp_die(sprintf(__('Error locating <code>%s</code> for inclusion.', 'thor'), $file), 'File not found');
//   }
// }, [
//   'blocks',
//   'patterns',
// ]);

add_action('enqueue_block_editor_assets', function () {
  wp_enqueue_script('thor-gutenberg', asset_path('scripts/gutenberg.js'), array('wp-blocks'), '1.0', true);
});

//custom styles
/**
 * Theme setup
 */
add_action('after_setup_theme', function () {
  // add_theme_support( 'dark-editor-style' );
  add_theme_support('editor-styles');
  add_theme_support('align-wide');
  add_theme_support('responsive-embeds');
  add_theme_support('wp-block-styles');
  add_theme_support('custom-line-height');
  add_theme_support('custom-spacing');
  add_theme_support('custom-units');

  add_editor_style(asset_path('styles/gutenberg.css'));

  // add_theme_support( 'disable-custom-colors' );

  add_theme_support('editor-color-palette', array(
    array(
      'name' => __('Primary', 'thor'),
      'slug' => 'primary',
      'color' => '#ff0033',
    ),
    array(
      'name' => __('Primary light', 'thor'),
      'slug' => 'primary-light',
      'color' => '#fff000',
    ),
    array(
      'name' => __('Primary dark', 'thor'),
      'slug' => 'primary-dark',
      'color' => '#283058',
    ),
    array(
      'name' => __('Gray light', 'thor'),
      'slug' => 'gray-200',
      'color' => '#eeeeee',
    ),
    array(
      'name' => __('Gray', 'thor'),
      'slug' => 'gray-500',
      'color' => '#999999',
    ),
    array(
      'name' => __('Gray dark', 'thor'),
      'slug' => 'gray-800',
      'color' => '#333333',
    ),
    array(
      'name' => __('White', 'thor'),
      'slug' => 'white',
      'color' => '#fff',
    ),
    array(
      'name' => __('Black', 'thor'),
      'slug' => 'black',
      'color' => '#000',
    ),
  ));

  // Next line disallow custom font size
  // add_theme_support('disable-custom-font-sizes');

  // Next line replace text sizes preset
  add_theme_support('editor-font-sizes', array(
    array(
      'name' => __('Extra small', 'thor'),
      'size' => 12,
      'slug' => 'extra-small'
    ),
    array(
      'name' => __('Small', 'thor'),
      'size' => 14,
      'slug' => 'small'
    ),
    array(
      'name' => __('Normal', 'thor'),
      'size' => 16,
      'slug' => 'normal'
    ),
    array(
      'name' => __('Large', 'thor'),
      'size' => 18,
      'slug' => 'large'
    ),
    array(
      'name' => __(
        'XL',
        'thor'
      ),
      'size' => 20,
      'slug' => 'xl'
    ),
    array(
      'name' => __('2XL', 'thor'),
      'size' => 22,
      'slug' => '2xl'
    ),
    array(
      'name' => __('3XL', 'thor'),
      'size' => 30,
      'slug' => '3xl'
    ),
    array(
      'name' => __('4XL', 'thor'),
      'size' => 36,
      'slug' => '4xl'
    ),
    array(
      'name' => __('5XL', 'thor'),
      'size' => 48,
      'slug' => '5xl'
    ),
    array(
      'name' => __('6XL', 'thor'),
      'size' => 64,
      'slug' => '6xl'
    )
  ));
});

/**
 * Block template for posts
 * @see https://www.billerickson.net/gutenberg-block-templates/
 *
 */
// add_action( 'init', function() {
//   //Creo un template per un post
//   $post_type_object = get_post_type_object( 'post' );
//   $post_type_object->template = array(
//     array( 'core/paragraph', array(
//       'placeholder' => 'Inserisci qui il sottotiolo',
//     ) ),
//     array( 'core/image', array(
//       'align' => 'wide',
//     ) ),
//     array( 'core/freeform', array(
//       'placeholder' => 'Inserisci il contenuto'
//     )),
//   );
//   $post_type_object->template_lock = 'all';
// });

//Create custom Gutenberg category
add_filter('block_categories', function ($categories, $post) {
  return array_merge(
    array(
      array(
        'slug' => 'thor-blocks',
        'title' => __('Custom Blocks', 'thor'),
      ),
    ),
    $categories
  );
}, 10, 2);


// add_filter( 'allowed_block_types', function ( $allowed_blocks, $post ) {
//   $allowed_blocks = array(
// 		'core/image',
// 		'core/paragraph',
// 		'core/heading',
// 		'core/list'
// 	);

//   return $allowed_blocks;
// }, 10, 2);
