<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use Emberware\Evidia\Toolkit\Field\WYSIWYG;
//use Emberware\Evidia\Toolkit\Field\Select2;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model emberware\evidia\update\custom\backend\models\Change */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="change-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'description')->widget(WYSIWYG::className()) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'update_type_id')->widget(Select2::classname(), [
                    'name' => 'update_type_id',
                    'class' => 'form-group update_type_ids form-control',
                    'value' => ArrayHelper::map($updateTypes, 'id', function ($updateType) {
                        return $updateType['name'];
                    }),
                    'id' => 'update_type_id',
                    'data' => ArrayHelper::map($updateTypes, 'id', function ($updateType) {
                        return $updateType['name'];
                    }),
                    'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select update type')]
                ])->label(Yii::t('app', 'UpdateType'));
            ?>
        </div>
    </div>
    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
