<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use Emberware\Evidia\Toolkit\Field\WYSIWYG;
//use Emberware\Evidia\Toolkit\Field\Select2;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model emberware\evidia\update\custom\backend\models\Package */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="package-form">

    <?php $form = ActiveForm::begin(); ?>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'description')->widget(WYSIWYG::className()) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'package_type_id')->widget(Select2::classname(), [
                    'name' => 'package_type_id',
                    'class' => 'form-group package_type_ids form-control',
                    'value' => ArrayHelper::map($packageTypes, 'id', function ($packageType) {
                        return $packageType['name'];
                    }),
                    'id' => 'package_type_id',
                    'data' => ArrayHelper::map($packageTypes, 'id', function ($packageType) {
                        return $packageType['name'];
                    }),
                    'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select package type')]
                ])->label(Yii::t('app', 'PackageType'));
            ?> 
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'project_id')->widget(Select2::classname(), [
                    'name' => 'project_id',
                    'class' => 'form-group project_ids form-control',
                    'value' => ArrayHelper::map($projects, 'id', function ($project) {
                        return $project['name'];
                    }),
                    'id' => 'project_id',
                    'data' => ArrayHelper::map($projects, 'id', function ($project) {
                        return $project['name'];
                    }),
                    'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select project type')]
                ])->label(Yii::t('app', 'Project'));
            ?>
        </div>
    </div>
    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
