<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use Emberware\Evidia\Toolkit\Field\WYSIWYG;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
/* @var $this yii\web\View */
/* @var $model emberware\evidia\update\custom\backend\models\Project */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="project-form">

    <?php $form = ActiveForm::begin(); ?>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'description')->widget(WYSIWYG::className()) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'project_type_id')->widget(Select2::classname(), [
                    'name' => 'project_type_id',
                    'class' => 'form-group project_type_ids form-control',
                    'value' => ArrayHelper::map($projectTypes, 'id', function ($projectType) {
                        return $projectType['name'];
                    }),
                    'id' => 'project_type_id',
                    'data' => ArrayHelper::map($projectTypes, 'id', function ($projectType) {
                        return $projectType['name'];
                    }),
                    'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select project type')]
                ])->label(Yii::t('app', 'ProjectType'));
            ?>
        </div>
    </div>
    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
