<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
//use Emberware\Evidia\Toolkit\Field\Select2;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
/* @var $this yii\web\View */
/* @var $model emberware\evidia\update\custom\backend\models\Version */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="version-form">

    <?php $form = ActiveForm::begin(); ?>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'description')->textarea(['rows' => 6]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'package_id')->widget(Select2::classname(), [
                    'name' => 'package_id',
                    'class' => 'form-group package_ids form-control',
                    'value' => ArrayHelper::map($packages, 'id', function ($package) {
                        return $package['name'];
                    }),
                    'id' => 'project_type_id',
                    'data' => ArrayHelper::map($packages, 'id', function ($package) {
                        return $package['name'];
                    }),
                    'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select package')]
                ])->label(Yii::t('app', 'Package'));
            ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'change_id')->widget(Select2::classname(), [
                    'name' => 'change_id',
                    'class' => 'form-group change_ids form-control',
                    'value' => ArrayHelper::map($changes, 'id', function ($change) {
                        return html_entity_decode($change['description']);
                    }),
                    'id' => 'project_type_id',
                    'data' => ArrayHelper::map($changes, 'id', function ($change) {
                        return html_entity_decode($change['description']);
                    }),
                    'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select change')]
                ])->label(Yii::t('app', 'Change'));
            ?>
        </div>
    </div>
    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
