<?php
namespace emberware\evidia\update\custom\common\behaviors;

use yii\base\Behavior;
use yii\db\ActiveRecord;
use Yii;

class CreateUpdateBehaviors extends Behavior
{

    public function events()
    {
        return [
            ActiveRecord::EVENT_BEFORE_INSERT => 'setCreate',
            ActiveRecord::EVENT_BEFORE_UPDATE  => 'setUpdate',
        ];
    }

    public function setCreate(){
        $this->owner->created_at = time();
        $this->owner->created_user_id = Yii::$app->user->id;
        $this->owner->updated_at = time();
        $this->owner->updated_user_id = Yii::$app->user->id;
    }

    public function setUpdate(){
        $this->owner->updated_at = time();
        $this->owner->updated_user_id = Yii::$app->user->id;
    }
}