<?php

namespace emberware\evidia\update\custom\common\models;

use Yii;
use Emberware\Evidia\Toolkit\Model\SoftDeleteBehavior;
use emberware\evidia\update\custom\common\behaviors\StatusBehaviors;
use emberware\evidia\update\custom\common\behaviors\CreateUpdateBehaviors;

/**
 * This is the model class for table "{{%Version}}".
 */
class Version extends base\Version
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
       ]);
    }
}
