<?php

namespace emberware\evidia\update\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%change}}".
 *
 * @property int $id
 * @property string|null $description
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 * @property int|null $update_type_id
 *
 * @property UpdateType $updateType
 */
class Change extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%change}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['description'], 'string'],
            [['status', 'created_user_id', 'updated_user_id', 'update_type_id'], 'integer'],
            [['created_at', 'updated_at'], 'string', 'max' => 255],
            [['update_type_id'], 'exist', 'skipOnError' => true, 'targetClass' => UpdateType::className(), 'targetAttribute' => ['update_type_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'description' => Yii::t('app', 'Description'),
            'status' => Yii::t('app', 'Status'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_user_id' => Yii::t('app', 'Created User ID'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_user_id' => Yii::t('app', 'Updated User ID'),
            'update_type_id' => Yii::t('app', 'Update Type ID'),
        ];
    }

    /**
     * Gets query for [[UpdateType]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getUpdateType()
    {
        return $this->hasOne(UpdateType::className(), ['id' => 'update_type_id']);
    }
}
