<?php

namespace emberware\evidia\update\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%sending_plan}}".
 *
 * @property int $id
 * @property string|null $email_list
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 */
class SendingPlan extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%sending_plan}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['status', 'created_user_id', 'updated_user_id'], 'integer'],
            [['email_list', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'email_list' => Yii::t('app', 'Email List'),
            'status' => Yii::t('app', 'Status'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_user_id' => Yii::t('app', 'Created User ID'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_user_id' => Yii::t('app', 'Updated User ID'),
        ];
    }
}
