<?php

namespace emberware\evidia\update\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%version}}".
 *
 * @property int $id
 * @property string|null $name
 * @property string|null $description
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 * @property int|null $package_id
 * @property int|null $change_id
 *
 * @property Change $change
 * @property Package $package
 */
class Version extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%version}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['description'], 'string'],
            [['status', 'created_user_id', 'updated_user_id', 'package_id', 'change_id'], 'integer'],
            [['name', 'created_at', 'updated_at'], 'string', 'max' => 255],
            [['change_id'], 'exist', 'skipOnError' => true, 'targetClass' => Change::className(), 'targetAttribute' => ['change_id' => 'id']],
            [['package_id'], 'exist', 'skipOnError' => true, 'targetClass' => Package::className(), 'targetAttribute' => ['package_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'name' => Yii::t('app', 'Name'),
            'description' => Yii::t('app', 'Description'),
            'status' => Yii::t('app', 'Status'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_user_id' => Yii::t('app', 'Created User ID'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_user_id' => Yii::t('app', 'Updated User ID'),
            'package_id' => Yii::t('app', 'Package ID'),
            'change_id' => Yii::t('app', 'Change ID'),
        ];
    }

    /**
     * Gets query for [[Change]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getChange()
    {
        return $this->hasOne(Change::className(), ['id' => 'change_id']);
    }

    /**
     * Gets query for [[Package]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPackage()
    {
        return $this->hasOne(Package::className(), ['id' => 'package_id']);
    }
}
