<?php

namespace emberware\evidia\update\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%package}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%Package}}`
 */
class M211018135351AddPackageTypeColumnToPackageTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%package}}', 'package_type_id', $this->integer(11)->null());

        // creates index for column `package_type_id`
        $this->createIndex(
            '{{%idx-package-package_type_id}}',
            '{{%package}}',
            'package_type_id'
        );

        // add foreign key for table `{{%Package}}`
        $this->addForeignKey(
            '{{%fk-package-package_type_id}}',
            '{{%package}}',
            'package_type_id',
            '{{%Package}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%Package}}`
        $this->dropForeignKey(
            '{{%fk-package-package_type_id}}',
            '{{%package}}'
        );

        // drops index for column `package_type_id`
        $this->dropIndex(
            '{{%idx-package-package_type_id}}',
            '{{%package}}'
        );

        $this->dropColumn('{{%package}}', 'package_type_id');
    }
}
