<?php

namespace emberware\evidia\update\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%package}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%Project}}`
 */
class M211018135446AddProjectIdColumnToPackageTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%package}}', 'project_id', $this->integer(11)->null());

        // creates index for column `project_id`
        $this->createIndex(
            '{{%idx-package-project_id}}',
            '{{%package}}',
            'project_id'
        );

        // add foreign key for table `{{%Project}}`
        $this->addForeignKey(
            '{{%fk-package-project_id}}',
            '{{%package}}',
            'project_id',
            '{{%Project}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%Project}}`
        $this->dropForeignKey(
            '{{%fk-package-project_id}}',
            '{{%package}}'
        );

        // drops index for column `project_id`
        $this->dropIndex(
            '{{%idx-package-project_id}}',
            '{{%package}}'
        );

        $this->dropColumn('{{%package}}', 'project_id');
    }
}
