<?php

namespace emberware\evidia\update\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%project}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%project_type}}`
 */
class M220107143947AddProjectTypeColumnToProjectTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%project}}', 'project_type_id', $this->integer()->null());

        // creates index for column `project_type_id`
        $this->createIndex(
            '{{%idx-project-project_type_id}}',
            '{{%project}}',
            'project_type_id'
        );

        // add foreign key for table `{{%project_type}}`
        $this->addForeignKey(
            '{{%fk-project-project_type_id}}',
            '{{%project}}',
            'project_type_id',
            '{{%project_type}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%project_type}}`
        $this->dropForeignKey(
            '{{%fk-project-project_type_id}}',
            '{{%project}}'
        );

        // drops index for column `project_type_id`
        $this->dropIndex(
            '{{%idx-project-project_type_id}}',
            '{{%project}}'
        );

        $this->dropColumn('{{%project}}', 'project_type_id');
    }
}
