<?php

namespace emberware\evidia\update\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%change}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%update_type}}`
 */
class M220117160835AddUpdateTypeColumnToChangeTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%change}}', 'update_type_id', $this->integer()->null());

        // creates index for column `update_type_id`
        $this->createIndex(
            '{{%idx-change-update_type_id}}',
            '{{%change}}',
            'update_type_id'
        );

        // add foreign key for table `{{%update_type}}`
        $this->addForeignKey(
            '{{%fk-change-update_type_id}}',
            '{{%change}}',
            'update_type_id',
            '{{%update_type}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%update_type}}`
        $this->dropForeignKey(
            '{{%fk-change-update_type_id}}',
            '{{%change}}'
        );

        // drops index for column `update_type_id`
        $this->dropIndex(
            '{{%idx-change-update_type_id}}',
            '{{%change}}'
        );

        $this->dropColumn('{{%change}}', 'update_type_id');
    }
}
