<?php

namespace emberware\evidia\update\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%version}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%package}}`
 */
class M220117161746AddPackageColumnToVersionTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%version}}', 'package_id', $this->integer()->null());

        // creates index for column `package_id`
        $this->createIndex(
            '{{%idx-version-package_id}}',
            '{{%version}}',
            'package_id'
        );

        // add foreign key for table `{{%package}}`
        $this->addForeignKey(
            '{{%fk-version-package_id}}',
            '{{%version}}',
            'package_id',
            '{{%package}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%package}}`
        $this->dropForeignKey(
            '{{%fk-version-package_id}}',
            '{{%version}}'
        );

        // drops index for column `package_id`
        $this->dropIndex(
            '{{%idx-version-package_id}}',
            '{{%version}}'
        );

        $this->dropColumn('{{%version}}', 'package_id');
    }
}
