<?php

namespace emberware\evidia\update\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%version}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%change}}`
 */
class M220117161808AddChangeIdColumnToVersionTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%version}}', 'change_id', $this->integer()->null());

        // creates index for column `change_id`
        $this->createIndex(
            '{{%idx-version-change_id}}',
            '{{%version}}',
            'change_id'
        );

        // add foreign key for table `{{%change}}`
        $this->addForeignKey(
            '{{%fk-version-change_id}}',
            '{{%version}}',
            'change_id',
            '{{%change}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%change}}`
        $this->dropForeignKey(
            '{{%fk-version-change_id}}',
            '{{%version}}'
        );

        // drops index for column `change_id`
        $this->dropIndex(
            '{{%idx-version-change_id}}',
            '{{%version}}'
        );

        $this->dropColumn('{{%version}}', 'change_id');
    }
}
