<?php
/*
Plugin Name: Easy gourmet
Description: Plugin per la gestione di Easy gourmet
Author: Emberware
Author URI: https://emberware.it/
Text Domain: easy_gourmet
Domain Path: /languages
License: GPL v2 or later
 */

if (!defined('ABSPATH')) {
    die();
}

if (!class_exists('EasyGourmet')) {

    class EasyGourmet
    {

        public function __construct()
        {
            $this->constants();
            $this->includes();
            $table_area = new Table_Area();
            $allergen = new Allergen();
            $product_area = new Product_Area();
            $beverage_area = new Beverage_Area();
            $food_area = new Food_Area();
            $ingredient = new Ingredient();
            $menu_timing = new Menu_Timing();
            $booking = new Booking();
            $payment_methods = new Payment_Methods();
            $table = new Table();
            $waiter = new Waiter();
            $menu = new Menu();
            $agreement = new Agreement();
            $easy_order = new Easy_Order();
            $course = new Course();
            $easy_printer = new Easy_Printer();
            $table_service = new Table_Service();
            $checkout = new Checkout();


            add_filter('acf/settings/save_json', array($this, 'my_acf_json_save_point'));
            add_filter('acf/settings/load_json', array($this, 'my_acf_json_load_point'));
        }

        public function constants()
        {
            if (!defined('EASYGOURMET_DIR')) {
                define('EASYGOURMET_DIR', plugin_dir_path(__FILE__));
            }

            if (!defined('EASYGOURMET_DIR_URL')) {
                define('EASYGOURMET_DIR_URL', plugin_dir_url(__FILE__));
            }
        }

        public function includes()
        {
            require_once EASYGOURMET_DIR . 'inc/cpt/class-booking.php';
            require_once EASYGOURMET_DIR . 'inc/cpt/class-payment-methods.php';
            require_once EASYGOURMET_DIR . 'inc/cpt/class-table.php';
            require_once EASYGOURMET_DIR . 'inc/cpt/class-waiter.php';
            require_once EASYGOURMET_DIR . 'inc/cpt/class-menu.php';
            require_once EASYGOURMET_DIR . 'inc/cpt/class-agreement.php';
            require_once EASYGOURMET_DIR . 'inc/cpt/class-table-area.php';
            require_once EASYGOURMET_DIR . 'inc/cpt/class-easy-order.php';
            require_once EASYGOURMET_DIR . 'inc/cpt/class-course.php';
            require_once EASYGOURMET_DIR . 'inc/cpt/class-table-service.php';
            require_once EASYGOURMET_DIR . 'inc/cpt/class-easy-printer.php';
            require_once EASYGOURMET_DIR . 'inc/cpt/class-checkout.php';

            require_once EASYGOURMET_DIR . 'inc/taxonomies/class-allergen.php';
            require_once EASYGOURMET_DIR . 'inc/taxonomies/class-beverage-area.php';
            require_once EASYGOURMET_DIR . 'inc/taxonomies/class-food-area.php';
            require_once EASYGOURMET_DIR . 'inc/taxonomies/class-ingredient.php';
            require_once EASYGOURMET_DIR . 'inc/taxonomies/class-menu-timing.php';
            require_once EASYGOURMET_DIR . 'inc/taxonomies/class-product-area.php';
        }

        public function my_acf_json_save_point( $path ) {

            // update path
            $path = EASYGOURMET_DIR . 'acf-json';


            // return
            return $path;

        }

        public function my_acf_json_load_point( $paths ) {

            // remove original path (optional)
            unset($paths[0]);


            // append path
            $paths[] = EASYGOURMET_DIR . 'acf-json';


            // return
            return $paths;

        }
    }
    $EasyGourmet = new EasyGourmet();
}
