<?php
class Plant
{
	public function __construct()
    {
        add_action('init', array($this, 'orto_botanico_create_cpt_plant'), 0);
	}
	
	public function orto_botanico_create_cpt_plant()
	{
		$labels = array(
			'name' => _x('Piante', 'Post Type General Name', 'orto_botanico'),
			'singular_name' => _x('Pianta', 'Post Type Singular Name', 'orto_botanico'),
			'menu_name' => __('Piante', 'orto_botanico'),
			'name_admin_bar' => __('Pianta', 'orto_botanico'),
			'archives' => __('Item Archives', 'orto_botanico'),
			'attributes' => __('Item Attributes', 'orto_botanico'),
			'parent_item_colon' => __('Parent Item:', 'orto_botanico'),
			'all_items' => __('All Items', 'orto_botanico'),
			'add_new_item' => __('Add New Item', 'orto_botanico'),
			'add_new' => __('Add New', 'orto_botanico'),
			'new_item' => __('New Item', 'orto_botanico'),
			'edit_item' => __('Edit Item', 'orto_botanico'),
			'update_item' => __('Update Item', 'orto_botanico'),
			'view_item' => __('View Item', 'orto_botanico'),
			'view_items' => __('View Items', 'orto_botanico'),
			'search_items' => __('Search Item', 'orto_botanico'),
			'not_found' => __('Not found', 'orto_botanico'),
			'not_found_in_trash' => __('Not found in Trash', 'orto_botanico'),
			'featured_image' => __('Featured Image', 'orto_botanico'),
			'set_featured_image' => __('Set featured image', 'orto_botanico'),
			'remove_featured_image' => __('Remove featured image', 'orto_botanico'),
			'use_featured_image' => __('Use as featured image', 'orto_botanico'),
			'insert_into_item' => __('Insert into item', 'orto_botanico'),
			'uploaded_to_this_item' => __('Uploaded to this item', 'orto_botanico'),
			'items_list' => __('Items list', 'orto_botanico'),
			'items_list_navigation' => __('Items list navigation', 'orto_botanico'),
			'filter_items_list' => __('Filter items list', 'orto_botanico'),
		);
		$args = array(
			'label' => __('Pianta', 'orto_botanico'),
			'description' => __('Piante dell\'orto', 'orto_botanico'),
			'labels' => $labels,
			'supports' => array('title', 'editor', 'comments', 'author'),
			'taxonomies' => array('classification'),
			'hierarchical' => false,
			'public' => true,
			'show_ui' => true,
			'show_in_menu' => true,
			'menu_position' => 5,
            'menu_icon' => 'dashicons-palmtree',
			'show_in_admin_bar' => true,
			'show_in_nav_menus' => true,
			'can_export' => true,
			'has_archive' => true,
			'exclude_from_search' => false,
			'publicly_queryable' => true,
			'capability_type' => 'page',
		);
		register_post_type('plant', $args);

	}
}