<?php

/**
 * Register all actions and filters for the plugin
 *
 * @link       http://emberware.it
 * @since      1.0.0
 *
 * @package    Ew_Unifi_Custom_Portal
 * @subpackage Ew_Unifi_Custom_Portal/includes
 */

/**
 * Register all actions and filters for the plugin.
 *
 * Maintain a list of all hooks that are registered throughout
 * the plugin, and register them with the WordPress API. Call the
 * run function to execute the list of actions and filters.
 *
 * @package    Ew_Unifi_Custom_Portal
 * @subpackage Ew_Unifi_Custom_Portal/includes
 * @author     Lorenzo Bellini <lorenzo.bellini@emberware.it>
 */
class Ew_Unifi_Custom_Portal_Authorize {

	/**
	 * The array of actions registered with WordPress.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      array    $actions    The actions registered with WordPress to fire when the plugin loads.
	 */
	protected $unifi_server;

	/**
	 * The array of filters registered with WordPress.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      array    $filters    The filters registered with WordPress to fire when the plugin loads.
	 */
	protected $filters;

	/**
	 * Initialize the collections used to maintain the actions and filters.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {

		$this->unifi_server = array(
          'unifiServer' => "https://solcocremona.myqnapcloud.com:8444",
          'unifiUser'   => "admin",
          'unifiPass'   => "admin"
        );

		// $this->unifi_server = array(
    //       'unifiServer' => "10.0.0.251:8443",
    //       'unifiUser'   => "admin",
    //       'unifiPass'   => "admin"
    //     );
		// $this->filters = array();

	}

	/**
	 * Send Authorization to unifi server
	 *
	 * @since    1.0.0
	 * @param    int               $id             	this is the mac address to authorize.
	 * @param    string            $minutes        	Number of minutes to authorize
	 * @param    string            $unifi						Parameters of the server.
	 */
	public function sendAuthorization($id, $minutes, $unifi) {
	  // Start Curl for login
	  $ch = curl_init();
	  // We are posting data
	  curl_setopt($ch, CURLOPT_POST, TRUE);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	  // Set up cookies
	  $cookie_file = $plugin_dir.'my_cookies';
	  curl_setopt($ch, CURLOPT_COOKIEJAR, $cookie_file);
	  curl_setopt($ch, CURLOPT_COOKIEFILE, $cookie_file);
	  // Allow Self Signed Certs
	  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
	  curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
	  curl_setopt($ch, CURLOPT_SSLVERSION, 1);
	  // Login to the UniFi controller
	  curl_setopt($ch, CURLOPT_URL, $unifi['unifiServer']."/api/login");

	  $data = json_encode(array("username" => $unifi['unifiUser'],"password" => $unifi['unifiPass']));
	  curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
	  curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
		$response = curl_exec($ch);
		echo '<!-- login_response: '.$response.' login_error: '.curl_error($ch).' -->';

	  // Send user to authorize and the time allowed
	  $data = json_encode(array(
	          'cmd'=>'authorize-guest',
	          'mac'=>$id,
	          'minutes'=>$minutes));

	  // Make the API Call
	  curl_setopt($ch, CURLOPT_URL, $unifi['unifiServer'].'/api/s/default/cmd/stamgr');
	  curl_setopt($ch, CURLOPT_POSTFIELDS, 'json='.$data);
	  curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
	  $response = curl_exec($ch);
		echo '<!-- API Call_response: '.$response.' API Call_error: '.curl_error($ch).' -->';


	  // Logout of the connection
	  curl_setopt($ch, CURLOPT_URL, $unifi['unifiServer']."/logout");
		$response = curl_exec($ch);
		echo '<!-- Logout_response: '.$response.' Logout_error: '.curl_error($ch).' -->';

		curl_close ($ch);
	  sleep(6); // Small sleep to allow controller time to authorize
	}

	public function authorize($id){
		$this->sendAuthorization($id, '480', $this->unifi_server);
	}

	public function gravityAuthorizeAfterSubmission($entry){
		$this->authorize(rgar( $entry, '2'));
	}

}
