<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              http://emberware.it
 * @since             1.0.0
 * @package           Ew_Unifi_Custom_Portal
 *
 * @wordpress-plugin
 * Plugin Name:       WP UNIFI Custom Portal
 * Plugin URI:        http://emberware.it
 * Description:       This is a short description of what the plugin does. It's displayed in the WordPress admin area.
 * Version:           1.0.0
 * Author:            Lorenzo Bellini
 * Author URI:        http://emberware.it
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       ew-unifi-custom-portal
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

define( 'PLUGIN_NAME_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-ew-unifi-custom-portal-activator.php
 */
function activate_ew_unifi_custom_portal() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-ew-unifi-custom-portal-activator.php';
	Ew_Unifi_Custom_Portal_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-ew-unifi-custom-portal-deactivator.php
 */
function deactivate_ew_unifi_custom_portal() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-ew-unifi-custom-portal-deactivator.php';
	Ew_Unifi_Custom_Portal_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_ew_unifi_custom_portal' );
register_deactivation_hook( __FILE__, 'deactivate_ew_unifi_custom_portal' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-ew-unifi-custom-portal.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_ew_unifi_custom_portal() {

	$plugin = new Ew_Unifi_Custom_Portal();
	$plugin->run();

}
run_ew_unifi_custom_portal();
