<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       http://emberware.it
 * @since      1.0.0
 *
 * @package    Ew_Unifi_Custom_Portal
 * @subpackage Ew_Unifi_Custom_Portal/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Ew_Unifi_Custom_Portal
 * @subpackage Ew_Unifi_Custom_Portal/includes
 * @author     Lorenzo Bellini <lorenzo.bellini@emberware.it>
 */
class Ew_Unifi_Custom_Portal_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'ew-unifi-custom-portal',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
