<?php
/**
 * Plugin Name: REST abbonamenti altreconomia
 * Plugin URI: http://emberware.it
 * Description: Aggiungo gli endpoint che servono per la connessione abbonamenti
 * Version: 1.0.0
 * Author: Emberware srls
 * Author URI: http://emberware.it
 * License: GPL2
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $plugin_dir;
$plugin_dir = plugin_dir_path( __FILE__ );

include $plugin_dir.'includes/curl-calls.php';

add_filter( 'woocommerce_cart_needs_shipping_address', '__return_true', 50 );

//  add_action( 'rest_api_init', 'add_ew_post_controllers', 12 );

if ( ! class_exists( 'EW_AE_abbonamenti_Controller' ) ) {
	// class EW_AE_abbonamenti_Controller extends WP_REST_Posts_Controller {
	class EW_AE_abbonamenti_Controller  {
		/**
		 * Register the routes for the objects of the controller.
		 */
		public static function register_routes() {
			// register_rest_route( 'ew/v1', 'main_posts', array(
			register_rest_route( 'ae/v1', 'user', array(
				'methods' => WP_REST_Server::READABLE,
				'callback' => 'ew_rest_abbonamenti_user',
				'args'            => array(
					'user_firstname' => array(
						'default' => false,
						'sanitize_callback' => 'sanitize_user',
					),
					'user_lastname' => array(
						'default' => false,
						'sanitize_callback' => 'sanitize_user',
					),
					'user_email' => array(
						'default' => false,
						'sanitize_callback' => 'sanitize_email',
					),
					'user_id' => array(
						'default' => false,
						'sanitize_callback' => 'absint',
					)
 				),
			) );
			register_rest_route( 'ae/v1', 'abbonamento', array(
				'methods' => WP_REST_Server::READABLE,
				'callback' => 'ew_rest_abbonamenti_abbonamento',
				'args'            => array(
					'tipo_abbonamento_id' => array(
						'default' => false,
						'sanitize_callback' => 'absint',
					),
					'number_from' => array(
						'default' => false,
						'sanitize_callback' => 'absint',
					),
					'number_to' => array(
						'default' => false,
						'sanitize_callback' => 'absint',
					),
					'abbonamento_id' => array(
						'default' => false,
						'sanitize_callback' => 'absint',
					),
					'user_email' => array(
						'default' => false,
						'sanitize_callback' => 'sanitize_email',
					),
					'user_id' => array(
						'default' => false,
						'sanitize_callback' => 'absint',
					)
 				),
			) );
			// register_rest_route( 'ae/v1', 'abb_sync', array(
			// 	'methods' => WP_REST_Server::READABLE,
			// 	'callback' => 'ew_rest_abbonamenti_sync',
      //           'args'            => array(
 		// 		),
			// ) );
		}
		public static function init(){
			add_action( 'rest_api_init', array( __CLASS__, 'register_routes' ), 12 );
		}
	}
	add_action( 'plugins_loaded', array( 'EW_AE_abbonamenti_Controller', 'init' ) );
}

function missing_notice() {
    ?>
    <div class="notice error is-dismissible">
		<p><strong><?php esc_html_e( 'REST Cremonaoggi', 'dueper' ); ?></strong> <?php esc_html_e( 'depends on the last version of WordPress REST API to work!', 'dueper' ); ?></p>
		<!-- <p><a href="<?php echo esc_url( $url ); ?>" class="button button-primary"<?php if ( $target ) : ?> target="_blank"<?php endif; ?>><?php esc_html_e( $action . ' Advanced Custom Fields', 'dueper' ); ?></a></p>-->
	</div>
    <?php
}
function ew_rest_abbonamenti_user( $request ) {
	$params = $request->get_params();
	$email = $params[ 'user_email' ];
	error_log('$email'.$email);
	$first_name = $params[ 'user_firstname' ];
	$last_name = $params[ 'user_lastname' ];
	$old_id = $params[ 'user_id' ];

	$user = get_user_by( 'email', $email );
	if (!$user){
		$userdata = array(
			'user_login'  =>  $email,
			'user_email'  =>  $email,
			'first_name'  =>  $first_name,
			'last_name'  =>  $last_name,
			'role'  =>  'customer',
			'user_pass'   =>  NULL  // When creating an user, `user_pass` is expected.
		);
		error_log('userdata:'.json_encode($userdata));
		$user_id = wp_insert_user( $userdata ) ;

		//On success
		if ( ! is_wp_error( $user_id ) ) {
			echo "User created : ". $user_id;
			error_log("User created : ". $user_id);
			update_user_meta( $user_id, 'old_id', $old_id );
		}else{
			echo "User error : ". json_encode($user_id);
			error_log("User error : ". json_encode($user_id));

		}

	}
	else {
		$user_id = $user->ID;
		echo "User already exists : ". $user_id;
		error_log("User already exists : ". $user_id);
		update_user_meta( $user_id, 'old_id', $old_id );
	}
}
function ew_rest_abbonamenti_abbonamento( $request ) {
	$params = $request->get_params();
	$tipo_abbonamento_id = $params[ 'tipo_abbonamento_id' ];
	$number_from = $params[ 'number_from' ];
	$number_to = $params[ 'number_to' ];
	$abbonamento_id = $params[ 'abbonamento_id' ];
	$user_email = $params[ 'user_email' ];
	$old_id = $params[ 'user_id' ];

    $start_date = ew_abbonamenti_get_date_from_magazine_number($number_from);
    $end_date = ew_abbonamenti_get_date_from_magazine_number($number_to+1);
		$user_args = array(
			'meta_key'			=> 'old_id',
			'meta_value'		=> '$old_id'
		);
		$wp_user_query = new WP_User_Query($user_args);
		$users = $wp_user_query->get_results();
		if (!empty($users)) {
			$user = $users[0];
		}else{
			$user = get_user_by( 'email', $user_email );
		}

    $args_user_memberships = array(
      'post_type'   => 'wc_user_membership',
      'post_status'   => 'any',
      'fields'   => 'ids',
        'meta_query' => array(
           array(
               'key' => 'abbonamento_id',
               'value' =>$abbonamento_id,
           ),
       ),
    );
	$user_membership_ids = get_posts( $args_user_memberships );
    if(!empty($user_membership_ids)){
        $user_membership_id = $user_membership_ids[0];
        ew_abbonamenti_set_time_limit($user_membership_id, $end_date);
    }
    elseif($user){
			// if user email exists create new membership
		$user_id = $user->ID;
		error_log ("User already exists : ". $user_id);

		$args_membership_plan = array(
		  'post_type'   => 'wc_membership_plan',
		  'fields'   => 'ids',
			'meta_query' => array(
			   array(
				   'key' => 'id_abbonamento_gestionale',
				   'value' =>$tipo_abbonamento_id,
			   ),
		   ),
		);
		$memberships = get_posts( $args_membership_plan );
		error_log('$memberships:'.$memberships[0]);

		if($memberships){
			if ( ! function_exists( 'wc_memberships' ) ) {
				return;
			}

			$args = array(
				// Enter the ID (post ID) of the plan to grant at registration
				'plan_id'       => $memberships[0],
				'user_id'       => $user_id,
				// 'start_date'    => $start_date,
				// 'end_date'      => $end_date,
			);
			// magic!
			$user_membership = wc_memberships_create_user_membership( $args );
			// Optional: get the new membership and add a note so we know how this was registered.
			$user_membership->add_note( 'Membership access granted from gestionale abbonamenti.' );

			// $user_membership = wc_memberships_get_user_membership( $user_id, $args['plan_id'] );
			// $user_membership->set_start_date( $start_date );
			$user_membership_id = $user_membership->get_id();
			ew_abbonamenti_set_time_limit ($user_membership_id, $end_date);
		}
		update_user_meta( $user_id, 'old_id', $old_id );
		update_post_meta( $user_membership->id, 'abbonamento_id', $abbonamento_id );
	}
}

function ew_rest_abbonamenti_sync( $request ) {
	$params = $request->get_params();
	$plan_id = $params[ 'plan_id' ];
	$user_membership_id = $params[ 'user_membership_id' ];
	$order_id = $params[ 'order_id' ];
	$product_id = $params[ 'product_id' ];
	$user_id = $params[ 'user_id' ];

	$args = array(
		'user_id' => $user_id,
		'product_id' => $product_id,
		'order_id' => $order_id,
		'user_membership_id' => $user_membership_id,
	);
  $plan = wc_memberships_get_membership_plan($plan_id); //viene mandato il plan completo
  ew_abbonamenti_send_to_gestionale( $plan, $args );
}

add_filter( 'wc_memberships_grant_access_from_new_purchase', 'ew_abbonamenti_regalo_amico_check', 1, 2 );
function ew_abbonamenti_regalo_amico_check( $grant_access, $args ) {
	// get all active memberships for the purchaser, regardless of status
	$memberships = wc_memberships_get_user_memberships( $args['user_id'] );
    $user_id = $args[user_id];
    $product_id = $args[product_id];
    $order_id = $args[order_id];

		$args_user_memberships = array(
			'post_type'   => 'wc_user_membership',
			'post_status'   => 'any',
			'fields'   => 'ids',
				'meta_query' => array(
					 array(
							 'key' => '_order_id',
							 'value' =>$order_id,
					 ),
			 ),
		);
	$user_membership_ids = get_posts( $args_user_memberships );
		if(!empty($user_membership_ids)){
			return false;
		}

    $order = new WC_Order($order_id);
    $product_item = ew_get_product_item_from_order ($product_id, $order);
    if ($product_item->get_meta('Regala o acquista', true ) == "Regalo per un amico"){
			// $plan_args = array(
			// 	'post_type' => 'wc_membership_plan',
			// 	'fields' => 'ids',
			// 	'meta_query' => array(
			// 	   array(
			// 	       'key' => '_product_ids',
			// 	       'value' => 'i:'.$product_id.';',
			// 	       'compare' => 'LIKE',
			// 	   )
			// 	)
			// );
			// $plans = new WP_Query($plan_args);
			// $plan_id = $plans[0];
			// $plan = wc_memberships_get_membership_plan($plan_id); //TODO recuperare funzione
			// ew_abbonamenti_send_to_gestionale( $plan, $args );
		return false;
	}
	return $grant_access;
}

//add_action('wc_memberships_user_membership_status_changed', 'ew_abbonamenti_send_to_gestionale', 10, 2 );
//add_action('wc_memberships_user_membership_saved', 'ew_abbonamenti_send_to_gestionale', 10, 2 );
//add_action('wc_memberships_user_membership_created', 'ew_abbonamenti_send_to_gestionale', 10, 2 );
add_action('wc_memberships_grant_membership_access_from_purchase', 'ew_abbonamenti_send_to_gestionale', 10, 2 );
function ew_abbonamenti_send_to_gestionale( $plan, $args ) {
	//check if the plan is abbonamenti
	error_log("plan: ".json_encode($plan));
	error_log("args: ".json_encode($args));
    $plan_id = $plan->id;
    if (empty($plan_id))
        $plan_id = 116;
    $user_id = $args[user_id];
    $product_id = $args[product_id];
    $order_id = $args[order_id];
    $user_membership_id = $args[user_membership_id];
		$abbonamento_is_subscription = get_post_meta($plan_id, 'is_subscription', true );

		if (!($abbonamento_is_subscription==1)) {
			return false;
		}

		$args_user_memberships = array(
			'post_type'   => 'wc_user_membership',
			'post_status'   => 'any',
			'fields'   => 'ids',
				'meta_query' => array(
					 array(
							 'key' => '_order_id',
							 'value' =>$order_id,
					 ),
			 ),
			 'post__not_in' => array( $user_membership_id ),
		);
		$user_membership_ids = get_posts( $args_user_memberships );
		if(!empty($user_membership_ids)){
			return false;
		}


    $order = new WC_Order($order_id);
    $product_item = ew_get_product_item_from_order ($product_id, $order);
    error_log("product_item: ".json_encode($product_item));
		// if ($product_item["Regala o acquista"]=="Acquisto Per me"){
	  //      if (!$product_item["Dove spedire"]=="Indirizzo del carrello")
	  //          if ($product_item["Dove spedire"]=="Indirizzo apposito"){
	  //              //TODO usa i dati di spedizione per l'abbonamento, tutto il resto rimane invariato
	  //          }
		 //
	  //  }else{
	  //      $user_id = 1; //TODO usa i dati dell'utente per recuperare l'ID, altrimenti usa quei dati per creare l'utente e impostare spedizione abbonamento
	  //  }
    // $product_value = $product_item[item_meta][_line_total][0];
    // if(empty($product_value))
    //     $product_value=321;
    //done TODO: check if user has old_id
    $old_id = get_user_meta( $user_id, 'old_id', true );
		// $abb = new Abbonamenti();
        //done TODO: check if old_id has user on gestionale
    if(!empty($old_id)){
        $has_user_id = ew_abbonamenti_check_user_from_user_old_id($old_id);
        error_log("has_user_id1: ".json_encode($has_user_id));
    }
        //done TODO: check if user email has account
    if(!$has_user_id){
        //TODO: se l'utente non ha impostato la mail? cancellare utenti senza mail?
        $user_email = get_userdata($user_id)->user_email;
        $has_user_id = ew_abbonamenti_check_user_from_user_email($user_email);
        if ($has_user_id)
            update_user_meta($user_id, 'old_id', $has_user_id);
        error_log("has_user_id2: ".json_encode($has_user_id));
    }
    if(!$has_user_id){
        //TODO: create user on abbonamenti gestionale
        $has_user_id = ew_abbonamenti_add_new_user($user_id);
        if ($has_user_id)
            update_user_meta($user_id, 'old_id', $has_user_id);
        error_log("has_user_id3: ".json_encode($has_user_id));
    }
    if($has_user_id){
        error_log("has_user_id: ".json_encode($has_user_id));
        //done TODO: if gestionale has account check if has active abbonamento
        $last_abbonamento = ew_abbonamenti_get_last_from_user_old_id($has_user_id);
        //TODO: if has active abb. renew on old_id
				// $last_abbonamento = ew_abbonamenti_create_new_abbonamento($has_user_id, $plan_id);
        if(!empty($last_abbonamento)){
            $abbonamento = ew_abbonamenti_renew($has_user_id, $last_abbonamento, $plan_id, $order, $product_item);
            update_post_meta($user_membership_id, 'abbonamento_id', $abbonamento['id']);
				    $end_date = ew_abbonamenti_get_date_from_magazine_number($abbonamento['numero_a']+1);
						ew_abbonamenti_set_time_limit($user_membership_id, $end_date);
						return true;
        }
        else{
            //TODO: else create new abbonamento on old_id
            $last_numero = ew_abbonamenti_get_last_rivista();
            $abbonamento = ew_abbonamenti_add_new($has_user_id, $last_numero, $plan_id, $order, $product_item);
            update_post_meta($user_membership_id, 'abbonamento_id', $abbonamento['id']);
				    $end_date = ew_abbonamenti_get_date_from_magazine_number($abbonamento['numero_a']+1);
						ew_abbonamenti_set_time_limit($user_membership_id, $end_date);
						return true;
        }
    }
		return false;

    //send data to gestionale

}

function ew_abbonamenti_set_time_limit ($user_membership_id, $end_date){
	$st_end_date = strtotime($end_date);
  $user_membership = wc_memberships_get_user_membership($user_membership_id);
  $user_membership->activate_membership();
	$user_membership->set_end_date( $st_end_date );
	$user_membership->add_note( 'end_date Updated via sync:'.$end_date );
}

function ew_abbonamenti_get_date_from_magazine_number($magazine_number){
  //  error_log('$magazine_number:'.$magazine_number);
    $magazine = get_term_by('name', $magazine_number, 'magazine-number');
  //  error_log('$magazine:'.json_encode($magazine));
    $magazine_date = get_option( 'magazine-number_'.$magazine->term_id.'_month' );
  //  $magazine_date = get_field('month', 'magazine-number_'.$magazine->term_id );
	// 	$end_date = date("Y-m-d", get_field('month', 'magazine-number_'.$magazine_to->term_id ).' + 1 month');
  //  error_log('$magazine_date:'.$magazine_date);
    return $magazine_date;
}

function ew_abbonamenti_menu (){
    add_menu_page('Abbonamenti', 'Abbonamenti', 'edit_others_posts', 'abbonamenti', null);
    add_submenu_page( 'abbonamenti', 'Gestione Abbonamenti', 'Gestione Abbonamenti', 'edit_others_posts', 'abbonamenti', 'Abbonamenti_iframe' );
    add_submenu_page( 'abbonamenti', 'Gestione Utenti', 'Gestione utenti', 'edit_others_posts', 'abbonamenti-utenti', 'Abbonamenti_iframe' );
    add_submenu_page( 'abbonamenti', 'Impostazione ultima rivista', 'Impostazione ultima rivista', 'edit_others_posts', 'abbonamenti-ultima', 'Abbonamenti_iframe' );
}
add_action('admin_menu', 'ew_abbonamenti_menu');

function Abbonamenti_iframe(){
    $page_title = get_admin_page_title();
    switch ($page_title) {
        case "Gestione Abbonamenti":
            $iframe_url = "http://abbonamenti-altreconomia.prod.emberware.it/admin/index.php?browse=1&m=abbonamenti";
            break;
        case "Gestione utenti":
            $iframe_url = "http://abbonamenti-altreconomia.prod.emberware.it/admin/index.php?browse=1&m=utenti";
            break;
        case "Impostazione ultima rivista":
            $iframe_url = "http://abbonamenti-altreconomia.prod.emberware.it/admin/index.php?custom=1&m=ultima_rivista";
            break;
    }
    echo '<iframe src="'.$iframe_url.'" style="border: 0; width: 100%; height: 100%">No iFrames.</iframe>';
}
