<?php
require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

function daneawoo_menu ()
{
	// TODO Gerstire i permessi: oer ora ho messo che il plugin è usabile da un utente che ha il permesso di edit_pages, poi sarebbe da creare una capabilitiy ad hoc

	 // add_menu_page( $page_title, $menu_title, $capability, $menu_slug, $function, $icon_url, $position )
	 add_menu_page('Danea WooCommerce', 'DaneaWoo', 'edit_pages', 'daneawoo-impostazioni', null, DANEAWOO_URL .'/icone/icona_plugin_danea_woocommerce.png');
	 
	 // add_submenu_page( $parent_slug, $page_title, $menu_title, $capability, $menu_slug, $function ); 
	 add_submenu_page( 'daneawoo-impostazioni', 'Impostazioni', 'Impostazioni', 'edit_pages', 'daneawoo-impostazioni', 'daneawoo_impostazioni' );
	 add_submenu_page( 'daneawoo-impostazioni', 'Upload prodotti', 'Upload prodotti', 'edit_pages', 'daneawoo', 'daneawoo_prodotti_import' );
	 add_submenu_page( 'daneawoo-impostazioni', 'Elimina tutti i prodotti', 'Elimina tutti i prodotti', 'edit_pages', 'daneawoo-prodotti-svuota', 'daneawoo_prodotti_svuota' );
	 add_submenu_page( 'daneawoo-impostazioni', 'Upload immagini', 'Upload immagini', 'edit_pages', 'daneawoo-prodotti-immagini', 'daneawoo_prodotti_immagini_import' ); 
	 add_submenu_page( 'daneawoo-impostazioni', 'Invia ordini a Danea', 'Donwload ordini', 'edit_pages', 'daneawoo-ordini', 'daneawoo_ordini_donwload' ); 
}

add_action('admin_menu', 'daneawoo_menu');

/******************************************************************************************************************************************************
************************************************************* DANEAWOO - IMPOSTAZIONI - INIZIO ********************************************************
******************************************************************************************************************************************************/
function daneawoo_impostazioni()
{
	if(isset($_POST['impostazioni_set']))
	{	
		/* Parametri azienda per download ordini */
		update_option('daneawoo_company_name', $_POST['company_name']);
		update_option('daneawoo_company_address', $_POST['company_address']);
		update_option('daneawoo_company_cap', $_POST['company_cap']);
		update_option('daneawoo_company_city', $_POST['company_city']);
		update_option('daneawoo_company_province', $_POST['company_province']);
		update_option('daneawoo_company_country', $_POST['company_country']);
		update_option('daneawoo_company_fiscalcode', $_POST['company_fiscalcode']);
		update_option('daneawoo_company_vatcode', $_POST['company_vatcode']);
		update_option('daneawoo_company_tel', $_POST['company_tel']);
		update_option('daneawoo_company_fax', $_POST['company_fax']);
		update_option('daneawoo_company_email', $_POST['company_email']);
		update_option('daneawoo_company_homepage', $_POST['company_homepage']);
		
		/* Parametri per gestione magazzino */
		if($_POST['stock']=="si")
			update_option('daneawoo_stock', true);
		else
			update_option('daneawoo_stock', false);
			
		/* Parametri per prodotti */
		update_option('daneawoo_product_custom_field_1', $_POST['custom_field_1']);
		update_option('daneawoo_product_custom_field_2', $_POST['custom_field_2']);
		update_option('daneawoo_product_custom_field_3', $_POST['custom_field_3']);
		update_option('daneawoo_product_custom_field_4', $_POST['custom_field_4']);
		update_option('daneawoo_product_tags', $_POST['tags']);
		update_option('daneawoo_grossprice',  $_POST['GrossPrice']);
		
		global $wpdb, $woocommerce;
		
		if(!empty($_POST['custom_field_1']))
		{
			if (!taxonomy_exists($woocommerce->attribute_taxonomy_name('pa_' . strtolower($_POST['custom_field_1'])))  and  !taxonomy_exists($woocommerce->attribute_taxonomy_name(strtolower($_POST['custom_field_1'])))  )
			{
				$wpdb->insert(
					$wpdb->prefix . 'woocommerce_attribute_taxonomies',
					 array(
						 'attribute_label'   => $_POST['custom_field_1'],
						 'attribute_name'    => strtolower($_POST['custom_field_1']),
						 'attribute_type'    => 'text',
						 'attribute_orderby' => 'menu_order'
					 )
				);	
			}	
		}
		
		if(!empty($_POST['custom_field_2']))
		{
			if (!taxonomy_exists($woocommerce->attribute_taxonomy_name('pa_' . strtolower($_POST['custom_field_2'])))  and   !taxonomy_exists($woocommerce->attribute_taxonomy_name(strtolower($_POST['custom_field_2'])))  )
			{
				$wpdb->insert(
					$wpdb->prefix . 'woocommerce_attribute_taxonomies',
					 array(
						 'attribute_label'   => $_POST['custom_field_2'],
						 'attribute_name'    => strtolower($_POST['custom_field_2']),
						 'attribute_type'    => 'text',
						 'attribute_orderby' => 'menu_order'
					 )
				);	
			}	
		}
		
		if(!empty($_POST['custom_field_3']))
		{
			if (!taxonomy_exists($woocommerce->attribute_taxonomy_name('pa_' . strtolower($_POST['custom_field_3'])))  and  !taxonomy_exists($woocommerce->attribute_taxonomy_name(strtolower($_POST['custom_field_3']))) )
			{
				$wpdb->insert(
					$wpdb->prefix . 'woocommerce_attribute_taxonomies',
					 array(
						 'attribute_label'   => $_POST['custom_field_3'],
						 'attribute_name'    => strtolower($_POST['custom_field_3']),
						 'attribute_type'    => 'text',
						 'attribute_orderby' => 'menu_order'
					 )
				);	
			}
		}	
		 
		if(!empty($_POST['custom_field_4']))
		{
			if (!taxonomy_exists($woocommerce->attribute_taxonomy_name('pa_' . strtolower($_POST['custom_field_4']))) and !taxonomy_exists($woocommerce->attribute_taxonomy_name(strtolower($_POST['custom_field_4']))) )
			{
				$wpdb->insert(
					$wpdb->prefix . 'woocommerce_attribute_taxonomies',
					 array(
						 'attribute_label'   => $_POST['custom_field_4'],
						 'attribute_name'    => strtolower($_POST['custom_field_4']),
						 'attribute_type'    => 'text',
						 'attribute_orderby' => 'menu_order'
					 )
				);	
			}	
		}
		
		
	}
	
	?> 
	<div class="wrap">
		<div class="icon32"><img src="<?php echo DANEAWOO_URL .'/icone/icona_plugin_danea_woocommerce_32x32.png' ?>" /><br></div>
		<h2>Impostazioni generali di DaneaWoo</h2>
		<form  action="admin.php?page=daneawoo-impostazioni" method="post" name="download_impostazioni_form" id="download_impostazioni_form">        
			<input type="hidden" id="impostazioni_set" name="impostazioni_set" value="si" />
			<table class="form-table">
				<tbody>
					<tr class="form-field">
						<th scope="row" colspan="2">
							<h3>Dati azienda</h3>
						  </th>
					</tr>
					<tr class="form-field">
						<th scope="row"><label for="firstdate">Denominazione</label></th>
						<td><input name="company_name" type="text" id="company_name" value="<?php echo get_option('daneawoo_company_name', '') ?>" style="width: 25em"></td>
					</tr>
					<tr class="form-field">
						<th scope="row"><label for="lastdate">Indirizzo</label></th>
						<td><input name="company_address" type="text" id="company_address" value="<?php echo get_option('daneawoo_company_address', '') ?>" style="width: 25em"></td>
					</tr>
					<tr class="form-field">
						<th scope="row"><label for="firstnum">Cap</label></th>
						<td><input name="company_cap" type="text" id="company_cap" value="<?php echo get_option('daneawoo_company_cap', '') ?>" style="width: 25em"> </td>
					</tr>
					<tr class="form-field">
						<th scope="row"><label for="lastnum">Città</label></th>
						<td><input name="company_city" type="text" id="company_city" value="<?php echo get_option('daneawoo_company_city', '') ?>" style="width: 25em"> </td>
					</tr>
					<tr class="form-field">
						<th scope="row"><label for="lastnum">Provincia</label></th>
						<td><input name="company_province" type="text" id="company_province" value="<?php echo get_option('daneawoo_company_province', '') ?>" style="width: 25em"> </td>
					</tr>
					<tr class="form-field">
						<th scope="row"><label for="lastnum">Nazione</label></th>
						<td><input name="company_country" type="text" id="company_country" value="<?php echo get_option('daneawoo_company_country', '') ?>" style="width: 25em"> </td>
					</tr>
					<tr class="form-field">
						<th scope="row"><label for="lastnum">Codice Fiscale</label></th>
						<td><input name="company_fiscalcode" type="text" id="company_fiscalcode" value="<?php echo get_option('daneawoo_company_fiscalcode', '') ?>" style="width: 25em"> </td>
					</tr>
					<tr class="form-field">
						<th scope="row"><label for="lastnum">Partita IVA</label></th>
						<td><input name="company_vatcode" type="text" id="company_vatcode" value="<?php echo get_option('daneawoo_company_vatcode', '') ?>" style="width: 25em"> </td>
					</tr>
					<tr class="form-field">
						<th scope="row"><label for="lastnum">Telefono</label></th>
						<td><input name="company_tel" type="text" id="company_tel" value="<?php echo get_option('daneawoo_company_tel', '') ?>" style="width: 25em"> </td>
					</tr>
					<tr class="form-field">
						<th scope="row"><label for="lastnum">Fax</label></th>
						<td><input name="company_fax" type="text" id="company_fax" value="<?php echo get_option('daneawoo_company_fax', '') ?>" style="width: 25em"> </td>
					</tr>
					<tr class="form-field">
						<th scope="row"><label for="lastnum">Email</label></th>
						<td><input name="company_email" type="text" id="company_email" value="<?php echo get_option('daneawoo_company_email', '') ?>" style="width: 25em"> </td>
					</tr>
					<tr class="form-field">
						<th scope="row"><label for="lastnum">Sito web</label></th>
						<td><input name="company_homepage" type="text" id="company_homepage" value="<?php echo get_option('daneawoo_company_homepage', '') ?>" style="width: 25em"> </td>
					</tr>
					<tr class="form-field">
						<th scope="row" colspan="2">
							<h3>Gestione magazzino</h3>
						  </th>
					</tr>
					 <tr class="form-field">
						<th scope="row"><label for="lastnum">Movimentazione del magazzino</label></th>
						<td>
                        <?php 
							$stock_checked = false;
							$stock_val = get_option('daneawoo_stock', '');
							if($stock_val == "1")
								$stock_checked = "checked";
							
						?>
                        <input name="stock" type="checkbox" id="stock" value="si" style="width: 5em" <?php echo $stock_checked ?>> Abilita movimentazione magazzino</td>
					</tr>
					<tr class="form-field">
						<th scope="row" colspan="2">
							<h3>Gestione prodotti</h3>
						  </th>
					</tr>
                    <tr class="form-field">
						<th scope="row"><label for="lastnum">Campo con il prezzo</label></th>
						<td><select id="GrossPrice" name="GrossPrice" style="width: 25em">
							<option id="custom_field_1" value="GrossPrice1" <?php if(get_option('daneawoo_grossprice', '') == "GrossPrice1") { echo "selected"; } ?>>Listino 1</option>
							<option id="custom_field_2" value="GrossPrice2" <?php if(get_option('daneawoo_grossprice', '') == "GrossPrice2") { echo "selected"; } ?>>Listino 2</option>
							<option id="custom_field_3" value="GrossPrice3" <?php if(get_option('daneawoo_grossprice', '') == "GrossPrice3") { echo "selected"; } ?>>Listino 3</option>
							<option id="custom_field_4" value="GrossPrice4" <?php if(get_option('daneawoo_grossprice', '') == "GrossPrice4") { echo "selected"; } ?>>Listino 4</option>
						</select></td>
					</tr>
                    <tr class="form-field">
						<th scope="row"><label for="lastnum">Campo libero contenente i tags</label></th>
						<td>
						<select id="tags" name="tags" style="width: 25em">
							<option id="custom_field_1" value="1" <?php if(get_option('daneawoo_product_tags', '') == "1") { echo "selected"; } ?>>Campo libero 1</option>
							<option id="custom_field_2" value="2" <?php if(get_option('daneawoo_product_tags', '') == "2") { echo "selected"; } ?>>Campo libero 2</option>
							<option id="custom_field_3" value="3" <?php if(get_option('daneawoo_product_tags', '') == "3") { echo "selected"; } ?>>Campo libero 3</option>
							<option id="custom_field_4" value="4" <?php if(get_option('daneawoo_product_tags', '') == "4") { echo "selected"; } ?>>Campo libero 4</option>
						</select>	
						</td>
					</tr>
					<tr class="form-field">
						<th scope="row"><label for="lastnum">Etichetta campo libero 1</label></th>
						<td><input name="custom_field_1" type="text" id="custom_field_1" value="<?php echo get_option('daneawoo_product_custom_field_1', '') ?>" style="width: 25em"> </td>
					</tr>        
					<tr class="form-field">
						<th scope="row"><label for="lastnum">Etichetta campo libero 2</label></th>
						<td><input name="custom_field_2" type="text" id="custom_field_2" value="<?php echo get_option('daneawoo_product_custom_field_2', '') ?>" style="width: 25em"> </td>
					</tr>
					<tr class="form-field">
						<th scope="row"><label for="lastnum">Etichetta campo libero 3</label></th>
						<td><input name="custom_field_3" type="text" id="custom_field_3" value="<?php echo get_option('daneawoo_product_custom_field_3', '') ?>" style="width: 25em"> </td>
					</tr>
					<tr class="form-field">
						<th scope="row"><label for="lastnum">Etichetta campo libero 4</label></th>
						<td><input name="custom_field_4" type="text" id="custom_field_4" value="<?php echo get_option('daneawoo_product_custom_field_4', '') ?>" style="width: 25em"> </td>
					</tr>
					
				</tbody>
			</table>               
			<p class="submit"><input type="submit" name="impostazioni_button" id="impostazioni_button" class="button button-primary" value="Salva impostazioni"></p>         
		</form>
	</div>   
	<?php
	
}

/******************************************************************************************************************************************************
************************************************************* DANEAWOO - IMPOSTAZIONI - FINE **********************************************************
******************************************************************************************************************************************************/


/******************************************************************************************************************************************************
******************************************************** DANEAWOO - IMPORTAZIONE PRODOTTI - INIZIO ****************************************************
******************************************************************************************************************************************************/
function daneawoo_prodotti_upload_file()
{
	?>
        <h4>Carica un file .xml o .txt con i prodotti da inserire/aggiornare</h4>
        <form method="post" enctype="multipart/form-data" class="wp-upload-form" action="admin.php?page=daneawoo" name="prodotti_carica_xml" id="prodotti_carica_xml">	
            <table class="form-table">
                <tbody>
                    <tr class="form-field">
                        <th scope="row"><label for="xml_prodotti">File .xml dei prodotti</label></th>
                        <td><input type="file" id="xml_prodotti" name="xml_prodotti" style="width: 45em"></td>
                    </tr>
                </tbody>
            </table>
            <p class="submit"><input type="submit" name="xml-prodotti-submit" id="xml-prodotti-submit" class="button  button-primary" value="Upload xml"></p>
        </form>
	<?php
}

function daneawoo_prodotti_import()
{

	// � stato caricato un file .xml usando direttamente la pagina
	if (isset($_FILES['xml_prodotti']))
	{
		?>
            <div class="wrap">
                <div class="icon32"><img src="<?php echo DANEAWOO_URL .'/icone/icona_plugin_danea_woocommerce_32x32.png' ?>" /><br></div>
                <h2>Importa prodotti</h2>
                <br />
        <?php
		
		// verifichiamo che l'utente abbia selezionato un file  
		if(trim($_FILES["xml_prodotti"]["name"]) == '')  
		{  
			echo '<div id="message" class="error below-h2"><p>Non hai selezionato nessun file!</p></div>';  
			daneawoo_prodotti_upload_file();
			die();
		}  
		// verifichiamo che il file � stato caricato  
		else if(!is_uploaded_file($_FILES["xml_prodotti"]["tmp_name"]) or $_FILES["xml_prodotti"]["error"]>0)  
      	{  
      		echo '<div id="message" class="error below-h2"><p>Si sono verificati problemi nella procedura di upload!</p></div>'; 
			daneawoo_prodotti_upload_file() ;
			die();
      	}
		
		$wp_filetype = wp_check_filetype(basename($_FILES["xml_prodotti"]["name"]), null );
		
		//if(! ($wp_filetype['ext'] == 'xml' or  $wp_filetype['ext'] == 'txt'))
		//{
			//echo '<div id="message" class="error below-h2"><p>' . $wp_filetype['ext'] . 'Il file caricato deve avere estensione .xml o .txt</p></div>'; 
			//daneawoo_prodotti_upload_file() ;
			//die();
		//}
		$count = importProdotti($_FILES["xml_prodotti"]);
		
		echo "<br ><div id='message' class='updated below-h2'><p>" . $count . " prodotti importati e/o aggiornati</p></div>";
		?>
	 		</div>
		<?php
	}
	// E' stato inviato un file direttamente da Danea $_FILES["file"]["tmp_name"]: percorso e il nome del file temporaneo sul server
	else if(isset($_FILES['file']))
	{
		$count = importProdotti($_FILES["file"]);
		// $count = 1026;
		if($count>0)
		{
			// Nel caso in cui il sito di e-commerce, al termine della ricezione dell'elenco prodotti, desideri ricevere anche le relative immagini, gli sar� necessario aggiungere,
			// successivamente all'OK di risposta, i seguenti parametri: ImageSendURL=URL e ImageSendFinishURL=URL (opzionale)
			// E' importante che le diverse righe contenenti OK, ImageSendURL e ImageSendFinishURL siano separate da un carattere di INVIO ("new line").
			// L'invio delle immagini in modalit� HTTP avverr� con un post per ciascun file trasmesso in modalit� Content-type "multipart/form-data" contenente due parametri:
			// "file" (il file trasmesso) e "fileName" (il nome del file).
			ob_clean();
			die("OK\r\nImageSendURL=http://" . $_SERVER['SERVER_NAME'] . "/wp-admin/admin.php?page=daneawoo-prodotti-immagini");	 
		}
		else
		{
			echo 'NESSUN prodotto da aggiornare ';
		}
		die();		
	}
	// nessun file da caricare, visualizzo la pagina per caricarlo
	else
	{
		?>
        <div class="wrap">
            <div class="icon32"><img src="<?php echo DANEAWOO_URL .'/icone/icona_plugin_danea_woocommerce_32x32.png' ?>" /><br></div>
            <h2>Importa prodotti</h2>
            <br />
        <?php
		daneawoo_prodotti_upload_file();
		?>
        	</div>
        <?php
		die();
	}	
}

/******************************************************************************************************************************************************
******************************************************** DANEAWOO - IMPORTAZIONE PRODOTTI - FINE ******************************************************
******************************************************************************************************************************************************/



/******************************************************************************************************************************************************
******************************************************** DANEAWOO - IMPORTAZIONE IMMAGINI PRODOTTI - INIZIO *******************************************
******************************************************************************************************************************************************/
function daneawoo_immagini_upload_form()
{
	?>
	<h4>Carica il file dell'immagine</h4>
	<form class="wp-upload-form" action="admin.php?page=daneawoo-prodotti-immagini" method="post" enctype="multipart/form-data"  name="foto_carica_form" id="foto_carica_form">
    <table class="form-table">
		<tbody>
			<tr class="form-field">
				<th scope="row"><label for="fileName">Nome file</label></th>
				<td><input type="text" name="fileName" id="fileName"  style="width: 25em" /></td>
			</tr>
            <tr class="form-field">
				<th scope="row"><label for="file">Immagine</label></th>
				<td><input type="file" name="file" if="file"  style="width: 45em" /></td>
			</tr>
    	</tbody>
     </table>
    <input type="hidden" id="da_pagina" name="da_pagina" value="si" />
    <p class="submit"><input type="submit" name="upload_buttone" id="upload_buttone" value="Upload" class="button  button-primary" /></p>
       
    </form>
	<?php
}

function daneawoo_prodotti_immagini_import()
{
	// L'invio delle immagini in modalita' HTTP avverra'' con un post per ciascun file trasmesso in modalita'' Content-type "multipart/form-data" contenente due parametri:
	// "file" (il file trasmesso) e "fileName" (il nome del file).
	if(isset($_FILES['file']) && isset($_POST['fileName']))
	{
		// arrivo direttamente da Danea quindi effettuo il login
		if(!isset($_POST['da_pagina']))
		{
			//	Commentato perchè danea non rimanda le credenziali inviando le immagini
			//	verificaCredenzialiDanea();
			$is_logged =  true; 
		}
		else
		{
			$is_logged = true;
			
			?>
                <div class="wrap">
                    <div class="icon32"><img src="<?php echo DANEAWOO_URL .'/icone/icona_plugin_danea_woocommerce_32x32.png' ?>" /><br></div>
                    <h2>Upload immagini prodotti</h2>
                    <br />
            <?php

		}
		
		
		if(	$is_logged )
		{
			$code_e_altro = explode(" -- ", $_POST['fileName']);
			
			$args_prodotto = array(
				'post_type' => 'product',
				'meta_query' => array(
					array(
						'key' => '_sku',
						'value' => $code_e_altro[0],
					)
				)
			 );
			$prodotto = get_posts( $args_prodotto );
			foreach($prodotto as $p)
			{
				 $prod = get_post($p->ID);
			}

			$nome_immagine = $code_e_altro[0];
			$nome_prodotto = $prod->post_name;
			$wp_filetype = wp_check_filetype(basename( $_FILES["file"]["name"]), null );
			$nome_immagine = basename($nome_prodotto) . "." . $wp_filetype['ext'];
		
			$percorso_file = ABSPATH . 'wp-content/uploads/images/products/' . $nome_immagine;
			
			// il move_uploaded_file dovrebbe sovrascrivere un file se ha lo stesso nome
			if(file_exists($percorso_file))
			{
				rename($percorso_file, $percorso_file.".old");
				// unlink($percorso_file);
			}
				move_uploaded_file( $_FILES["file"]["tmp_name"], $percorso_file);
				
				if(!isset($_POST['da_pagina']))
					die("OK");
				else
					echo "<br ><div id='message' class='updated below-h2'><p>Immagine " . $nome_immagine . " uploadata</p></div>";
			/*}
			else
				if(!isset($_POST['da_pagina']))
					die("OK");
				else
					echo "Immagine gia' presente";*/
		}
		else
		{
			if(!isset($_POST['da_pagina']))
				die("Non hai il permesso di portare a termine l'operazione richiesta");
			else
				echo "Non hai il permesso di portare a termine l'operazione richiesta";
		}
	}
	// non sto inviando le immagini da Danea, quindi mostro la pagina per il caricamento manuale
	else
	{
		?>
            <div class="wrap">
                <div class="icon32"><img src="<?php echo DANEAWOO_URL .'/icone/icona_plugin_danea_woocommerce_32x32.png' ?>" /><br></div>
                <h2>Upload immagini prodotti</h2>
                <br />
        <?php
		daneawoo_immagini_upload_form();
	}
?>
    </div>
<?php	
}

/******************************************************************************************************************************************************
******************************************************** DANEAWOO - IMPORTAZIONE IMMAGINI PRODOTTI - FINE *********************************************
******************************************************************************************************************************************************/
function mostra_pagina_prodotti_svuota()
{
?>
<h4>Eliminazione di tutti i prodotti</h4>
	<h3>Attenzione! Cliccando il bottone verranno eliminati tutti i prodotti e le categorie associate ai prodotti.</h3>
	<form action="admin.php?page=daneawoo-prodotti-svuota" method="post" name="svuota_prodotti_form" id="svuota_prodotti_form">
    	<input type="hidden" id="da_pagina" name="da_pagina" value="si" />
		<p class="submit"><input type="submit" name="svuota_prodotti_button" id="svuota_prodotti_button" class="button button-primary" value="Elinina TUTTI i prodotti"></p>
    </form>
	<?php
}

function daneawoo_prodotti_svuota()
{
	if(!isset($_POST['da_pagina']))
	{
		mostra_pagina_prodotti_svuota();
	}
	else
	{
		$prod_del = cancellaTuttiIProdotti();
		echo "Sono stati cancellati " . $prod_del . " prodotti";
	}
}




/******************************************************************************************************************************************************
******************************************************** DANEAWOO - ESPORTAZIONE ORDINI - INIZIO ******************************************************
******************************************************************************************************************************************************/
function daneawoo_ordini_imposta_valori()
{
	?> 
	<h4>Impostare i parametri per filtrare gli ordini. Se nessun parametro è impostato vengono scaricati tutti gli ordini presenti.</h4>
	<form action="admin.php?page=daneawoo-ordini" method="post" name="download_ordini_form" id="download_ordini_form">
	
	<table class="form-table">
		<tbody>
			<tr class="form-field">
				<th scope="row"><label for="firstdate">Data minima degli ordini</label></th>
				<td><input name="firstdate" type="text" id="firstdate" value="" style="width: 130px"> <span class="description">(formato aaaa-mm-gg es. "2013-12-01")</span></td>
			</tr>
			<tr class="form-field">
				<th scope="row"><label for="lastdate">Data massima degli ordini</label></th>
				<td><input name="lastdate" type="text" id="lastdate" value="" style="width: 130px"> <span class="description">(formato aaaa-mm-gg es. "2013-12-01")</span></td>
			</tr>
			<tr class="form-field">
				<th scope="row"><label for="firstnum">Primo nr. ordine da scaricare</label></th>
				<td><input name="firstnum" type="text" id="firstnum" value="" style="width: 70px"> </td>
			</tr>
			<tr class="form-field">
				<th scope="row"><label for="lastnum">Ultimo nr. ordine da scaricare</label></th>
				<td><input name="lastnum" type="text" id="lastnum" value="" style="width: 70px"> </td>
				
				<input type="hidden" id="da_pagina" name="da_pagina" value="si" />
				<input type="hidden" id="appver" name="appver" value="2" />
			</tr>
			<tr class="form-field">
				<th scope="row"><label for="group_type">Tipo di Gruppo</label></th>
				<td><select name="group_type" id="group_type" style="width: 70px">
					<option value="gruppo">GAS referente</option>
					<option value="gruppo-b">GAS centro</option>
				</SELECT> </td>
			</tr>
		</tbody>
	</table>
	
	<p class="submit"><input type="submit" name="download_ordini_button" id="download_ordini_button" class="button button-primary" value="Scarica gli ordini"></p>
	 
    </form>
	<?php
}

// crea il filtro per la query per l'estrazione degli ordini
function where_ordini( $where = '' )
{
    global $wpdb;
	
	if(isset($_POST['firstdate']) && $_POST['firstdate'] != "")
	{
		$firstdate = $_POST['firstdate'];
		$where_sql = $where_sql . " AND post_date >= '" . date('Y-m-d H:i:s', strtotime($firstdate) . " 00:00:01") . "'";
	}
	if(isset($_POST['lastdate']) && $_POST['lastdate'] != "")
	{
		$lastdate = $_POST['lastdate'];	
		$where_sql = $where_sql . " AND post_date <= '" . date('Y-m-d H:i:s', strtotime($lastdate . " 23:59:59")) . "'";
	}
	if(isset($_POST['firstnum']) && $_POST['firstnum'] != "")
	{
		$firstnum = $_POST['firstnum'];	
		$where_sql = $where_sql . " AND id >= " . $firstnum;
	}	
	if(isset($_POST['lastnum']) && $_POST['lastnum'] != "")
	{
		$lastnum = $_POST['lastnum'];	
		$where_sql = $where_sql . " AND id <= " . $lastnum;
	}	
	
	$where =  $wpdb->prepare(" AND post_type = %s " . $where_sql,  "shop_order");
 
    return $where;
}

function daneawoo_ordini_donwload() {
	// se è definito o arrivo da Danea che me lo invia oppure dalla pagina
	if(isset($_POST['appver']) || isset($_GET['appver']))
	{
		
		if(!isset($_POST['da_pagina']))
		{
			$is_logged =  true; //verificaCredenzialiDanea();
			$is_logged =  verificaCredenzialiDanea();
		}
		else
		{
			$is_logged = true;
			
			?>
                <div class="wrap">
                    <div class="icon32"><img src="<?php echo DANEAWOO_URL .'/icone/icona_plugin_danea_woocommerce_32x32.png' ?>" /><br></div>
                    <h2>Download ordini</h2>
                    <br />
            <?php

		}
		
		if(	$is_logged )
		{
			$xml = new DOMDocument('1.0', 'UTF-8');
	
			$ele_easyfattDoc = $xml->createElement('EasyfattDocuments');
			
			$attr_app_version = $xml->createAttribute('AppVersion');
			$attr_app_version->value = '2';
			$ele_easyfattDoc->appendChild($attr_app_version);
			
			$attr_app_creator = $xml->createAttribute('Creator');
			$attr_app_creator->value = 'Danea Soft';
			$ele_easyfattDoc->appendChild($attr_app_creator);
			
			$attr_app_url = $xml->createAttribute('CreatorUrl');
			$attr_app_url->value = 'www.danea.it';
			$ele_easyfattDoc->appendChild($attr_app_url);
			
		    /************ BEGIN COMPANY - dati del negozio ************/
			$ele_company = $xml->createElement('Company');
			
			//  get_option( $option, $default ); -> se l'option esiste la restituisce, altrimenti restituisce il valore in $default
			$ele_company_name = $xml->createElement('Name', get_option('daneawoo_company_name', ''));
			$ele_company->appendChild($ele_company_name);
			$ele_company_adress = $xml->createElement('Address', get_option('daneawoo_company_address', ''));
			$ele_company->appendChild($ele_company_adress);
			$ele_company_postcode = $xml->createElement('Postcode', get_option('daneawoo_company_cap', ''));
			$ele_company->appendChild($ele_company_postcode);	
			$ele_company_city = $xml->createElement('City', get_option('daneawoo_company_city', ''));
			$ele_company->appendChild($ele_company_city);	
			$ele_company_province = $xml->createElement('Province', get_option('daneawoo_company_province', ''));
			$ele_company->appendChild($ele_company_province);	
			$ele_company_country = $xml->createElement('Country', get_option('daneawoo_company_country', ''));
			$ele_company->appendChild($ele_company_country);	
			$ele_company_fiscalcode = $xml->createElement('FiscalCode', get_option('daneawoo_company_fiscalcode', ''));
			$ele_company->appendChild($ele_company_fiscalcode);	
			$ele_company_piva = $xml->createElement('VatCode', get_option('daneawoo_company_vatcode', ''));
			$ele_company->appendChild($ele_company_piva);	
			$ele_company_tel = $xml->createElement('Tel', get_option('daneawoo_company_tel', ''));
			$ele_company->appendChild($ele_company_tel);	
			$ele_company_fax = $xml->createElement('Fax', get_option('daneawoo_company_fax', ''));
			$ele_company->appendChild($ele_company_fax);	
			$ele_company_email = $xml->createElement('Email', get_option('daneawoo_company_email', ''));
			$ele_company->appendChild($ele_company_email);	
			$ele_company_web = $xml->createElement('HomePage', get_option('daneawoo_company_homepage', ''));
			$ele_company->appendChild($ele_company_web);
			$ele_easyfattDoc->appendChild($ele_company);	
			/************ END COMPANY - dati del negozio ************/
			
			
			/************ BEGIN DOCUMENTS ************/
			$ele_documents = $xml->createElement('Documents');
			
			
			
			
			// add_filter('posts_where', 'where_ordini');			
			// $orderlist = get_posts( array( 'posts_per_page'   => -1, 'suppress_filters' => false ) );
			// Important to avoid modifying other queries
			// remove_filter( 'posts_where', 'where_ordini');

			
			
			/*BEGIN - LORENZO*/

				if(isset($_POST['group_type']) && $_POST['group_type'] != "") {
					$tipo_di_gruppo = $_POST['group_type'];
				}

			$gruppi_args = array(
				'post_type' => $tipo_di_gruppo,
				'orderby' => 'title',
				'order' => 'ASC',
				'nopaging' => true,
			);
			/*seleziono gruppi*/
			$gruppi = get_posts($gruppi_args);
			// echo json_encode($_POST);
			foreach($gruppi as $gruppo){
				$gruppo_print="";
				$ordini_gruppo_count=0;
				$ordini_gruppo_tot=0;
				$fee_gruppo_tot=0;
				// echo json_encode($gruppo)."<br><br>";
				if ($tipo_di_gruppo == 'gruppo'){
					$utenti_gruppo = "utenti_gruppo";
				}
				else{
					$utenti_gruppo = "utenti_gruppo_b";
				}
				$utenti_args = array(
					'connected_type' => $utenti_gruppo,
					'connected_items' => $gruppo,
					'orderby' => 'display_name',
					'order' => 'ASC',
					'fields' => 'ID',
				);
				/* EW-LORENZO
				 * stampa titolo gruppo
				 */
				$gruppo_title = $gruppo->post_title;
				$time = time();
				$now = date('j',$time)."/".date('m',$time)."/".date('Y',$time); 
		
				$gruppo_print.= "<h2>Gruppo ".$gruppo_title." - Consegna del ".$now."</h2>";
		
				/*seleziono utenti per ciascun gruppo*/
				$utenti_query = get_users( $utenti_args );
				// echo json_encode($utenti_query)."<br>";
				// echo json_encode($utenti_gruppo)."<br>";
				$ordini_ids = array();
				foreach ($utenti_query as $utente_id) {
					$ordini_ids_args = array(
						'post_type' => 'shop_order',
						'post_status' => 'wc-processing',
						'nopaging' => true,
						'fields' => 'ids',
						// 'posts_per_page'=>-1,
						// 'order'   => 'ASC',
						// 'orderby'   => 'meta_value',
						// 'meta_key' => '_customer_user',
						'meta_query' => array(
							array(
								'key' => '_customer_user',
								'value' => $utente_id,
								// 'compare' => 'IN'
								)
							)
						);

						$ordini_ids_query = get_posts($ordini_ids_args);
						if (!empty($ordini_ids_query)) {
							$ordini_ids = array_merge($ordini_ids, $ordini_ids_query);
						}
						wp_reset_query();
					}
				// echo "ordini_id:".json_encode($ordini_ids).'<br/>';
				if(!empty($ordini_ids)){
					// echo "utenti si";
					$ordini_args = array(
						'post_type' => 'shop_order',
						'post_status' => 'wc-processing',
						'nopaging' => true,
						'post__in'   => $ordini_ids,
						// 'posts_per_page'=>-1,
						// 'order'   => 'ASC',
						'orderby'   => 'post__in',

					);
					/*seleziono gli ordini degli utenti del gruppo*/
					$ordini_query = get_posts($ordini_args);
					// echo json_encode($ordini_query)."<br>";
					if($ordini_query){
						$order_products = array();
						$temp_group_order = wc_create_order();
						$fee_totals=0;
						$last_customer_head="";
						$last_customer_print="";
						$last_customer_payment_method = "";
						$last_customer_fee="";
						
						foreach($ordini_query as $order){
							$ordini_gruppo_count++;
							$ordini_fee_count++;
							$codice_ordinamento = "";
							$the_order = new WC_Order( $order->ID );
							// echo json_encode($the_order)."<br>";
							
							/* EW-LORENZO
							 * BEGIN aggregazione elenchi stesso utente
							 */
							$customer_id = get_post_meta( $order->ID, '_customer_user', true );
							$customer = get_userdata( $customer_id );
							$same_customer=true;
							if (!($customer->first_name.$customer->last_name == $customer_name)){
								// echo $customer_name." not same ";
								$customer_name = $customer->first_name.$customer->last_name;
								// echo $customer_name." <br/>";
								$gruppo_print.= $last_customer_head;
								$gruppo_print.= $last_customer_print;
								$gruppo_print.= "<br/><br/>";
								$last_customer_head="";								
								$last_customer_payment_method = "";
								$last_customer_print="";
								$last_customer_fee="";
								$same_customer=false;
							}
							// echo $customer_name."<br/>";
							$order_total = $the_order->get_total();
							$ordini_gruppo_tot+= $order_total;
							if($same_customer){
								$customer_order_total += $order_total;
							}
							else {
								$customer_order_total = $order_total;
							}
							
							// echo "<b>".$customer->first_name." ".$customer->last_name." (".$order_total." euro)</b><br> ";
							$last_customer_head = "<b>".$customer->first_name." ".$customer->last_name." (".$customer_order_total." euro) ";

							//Add Phone_number
							$phone_number = get_user_meta( $customer->ID, 'Phone_number', true );

							if(!empty($phone_number)){
								$last_customer_head .= "- Telefono: ".$phone_number;
							}

							$last_customer_head .= "</b><br>";

							/* EW-LORENZO
							 * END aggregazione elenchi stesso utente
							 */
							
							$items = $the_order->get_items();
							// echo json_encode($items)."<br>";
							
							if($last_customer_payment_method == ""){
								$payment_method = $the_order->payment_method_title;
								$last_customer_payment_method .= "<b>Metodo di pagamento: ".$the_order->payment_method_title."";
								
							}else{
								if($payment_method != $the_order->payment_method_title){
									$last_customer_payment_method .= " - ".$the_order->payment_method_title;
									$payment_method = $the_order->payment_method_title;
								}
							}
							

							$ordered_items=array();
							$product_id = "";
							foreach ($items as $item_key => $item ){
								$product_id = $item['product_id'];
								$codice_ordinamento = get_post_meta( $product_id, 'codice_ordinamento', true ).'-'.$item_key.'-'.strtotime("now");
								$ordered_items[$codice_ordinamento]=$item;
							}
							ksort($ordered_items);
							$product_id = "";
							foreach ($ordered_items as $item_key => $item ){
								$product_id = $item['product_id'];
								$codice_ordinamento = get_post_meta( $product_id, 'codice_ordinamento', true ).'-'.$item_key.'-'.strtotime("now");
								$prodotto = get_post($product_id)->post_title;
								// echo json_encode($product)."<br>";
								$quantita = $item['qty'];
								$prezzo = $item['line_total'];
								
								/* EW-LORENZO
								 * gestione stampa pezzi
								 */
								$unita_vendita = get_post_meta( $product_id, 'unita_vendita', true );
								$unita_misura = get_post_meta( $product_id, 'unita_misura', true );
								if ($unita_misura=="pz"){
								$quantita_venduta = $quantita." pz x ".$unita_vendita;
								}
								else {
									$tmp_int = round(($unita_vendita*$quantita), 2);
									$quantita_venduta = "TOT: ".$tmp_int." ".$unita_misura;
								}
								$last_customer_print .= round($quantita,2)." x ".$prodotto." (".$quantita_venduta.") - euro ".number_format($prezzo,2)."<br>";
								// $last_customer_print .= $quantita." x ".$prodotto." (".$quantita_venduta.") - euro ".number_format($prezzo,2)."ord:".$codice_ordinamento."<br>";
								// echo $quantita." x ".$prodotto." (".$prezzo." euro)<br>";
								
								// echo $product_id." ";
								// if ($product_id == $product_id_selected){
									// var_dump($item);
									// echo json_encode($item);
									// $totale_quantita_vendita= $totale_quantita_vendita+$quantita_vendita;
									// echo " <input type=\"text\" name=\"order_".$order->ID."item_".$item_key."\" value=\"".$quantita_vendita."\"> ".$unita_misura."<br> ";
									// echo "Quantità originale: ".$item['qty']."*".$unita_vendita."= ".$quantita_vendita." ".$unita_misura."<br>";
								// }
								
								
								/* EW-LORENZO
								 * calcolo totali
								 */
								$order_product[id] = $product_id;
								$order_product[prezzo] = $prezzo;
								$order_product[quantita] = $quantita;
								$product_exist = false;
								foreach($order_products  as $product_key => $current_order_product){
									if ($current_order_product[id]==$order_product[id]){
										// echo " yes <br>";
										// echo $current_order_product[prezzo]." ";
										$order_products[$product_key][prezzo]+= $order_product[prezzo];
										// echo $current_order_product[prezzo]." - q ";
										// echo $current_order_product[quantita]." ";
										$order_products[$product_key][quantita]+= $order_product[quantita];
										// echo $current_order_product[quantita]."<br>";
										$product_exist=true;
									}
								}
								
								// echo 'codice_ordinamento: '.$codice_ordinamento;
								// if (empty($codice_ordinamento)){
									// $codice_ordinamento = strtotime("now");
									// echo 'now: '.$codice_ordinamento;
								// }
								
								if(!$product_exist){
									$order_products[$codice_ordinamento] = $order_product;
									// array_push($order_products, $order_product);
								}else{
									// echo json_encode($order_products)."<br>";
								}
							}
							$fees = $the_order->get_fees();
							foreach ($fees as $fee_key => $fee ){
								// echo json_encode($fee);
								$fee_name = $fee['name'];
								$costo = $fee['line_total'];
								$fee_totals+=$costo;
								
								if($same_customer){
									$customer_fee_total += $costo;
								}
								else {
									$customer_fee_total = $costo;
								}
								
								
							}
						}
						ksort($order_products);
						
						/* EW-LORENZO
						 * BEGIN stampa ordini gruppo
						 */
						

						$gruppo_print.= $last_customer_head;
						$gruppo_print.= $last_customer_payment_method."</b><br>";
						$gruppo_print.= $last_customer_print;
						$gruppo_print.= "<br/><br/>";
						$multi="ordine";
						if($ordini_gruppo_count>1){
							$multi="ordini";
						}
						$ordini_gruppo_prodotti=$ordini_gruppo_tot-$fee_gruppo_tot;
						
						$gruppo_print.= "<b>".$ordini_gruppo_count." ".$multi."</b><br/>";
						
						$gruppo_print.= "<br/><b>Prodotti Gruppo:</b><br/>";

						foreach($order_products as $current_order_product){
							
							// $product = new WC_Product($current_order_product[id]);
							
							// $item_id= $temp_group_order->add_product($product, $current_order_product[quantita]);
							// wc_update_order_item_meta($item_id, "_qty", $current_order_product[quantita]);
							// wc_update_order_item_meta($item_id, "_line_subtotal", $current_order_product[prezzo]);
							// wc_update_order_item_meta($item_id, "_line_total", $current_order_product[prezzo]);
							
							$product_id = $current_order_product[id];
							$prodotto = get_post($product_id)->post_title;
							// echo json_encode($product)."<br>";
							$quantita = $current_order_product[quantita];
							$prezzo = $current_order_product[prezzo];
							
							/* EW-LORENZO
							 * gestione stampa pezzi
							 */
							$unita_vendita = get_post_meta( $product_id, 'unita_vendita', true );
							$unita_misura = get_post_meta( $product_id, 'unita_misura', true );
							if ($unita_misura=="pz"){
							$quantita_venduta = $quantita." pz x ".$unita_vendita;
							}
							else {
								$tmp_int = round(($unita_vendita*$quantita), 2);
								$quantita_venduta = "TOT: ".$tmp_int." ".$unita_misura;
							}
//							$gruppo_print.= $quantita." x ".$prodotto." (".$quantita_venduta.") - euro ".number_format($prezzo,2)."<br>";
							$gruppo_print.= round($quantita,2)." x ".$prodotto." (".$quantita_venduta.") - euro ".number_format($prezzo,2)."<br>";
						}
						/* EW-LORENZO
						 * END stampa ordini gruppo
						 */
						 
						// echo json_encode($order_products);
						foreach($order_products as $current_order_product){
							$product = new WC_Product($current_order_product[id]);
							
							$item_id= $temp_group_order->add_product($product, $current_order_product[quantita]);
							wc_update_order_item_meta($item_id, "_qty", $current_order_product[quantita]);
							wc_update_order_item_meta($item_id, "_line_subtotal", $current_order_product[prezzo]);
							wc_update_order_item_meta($item_id, "_line_total", $current_order_product[prezzo]);
						}
						
//						$feename = "Donazione";
//						$new_fee_id = sanitize_title( $feename );
//						$new_fee            = new stdClass();
//						$new_fee->id        = $new_fee_id;
//						$new_fee->name      = esc_attr( $feename );
//						$new_fee->amount    = (float) esc_attr( $fee_totals );
//						$new_fee->tax_class = '';
//						$new_fee->taxable   = false;
//						$new_fee->tax       = 0;
//						$new_fee->tax_data  = array();
//						// $this->fees[]       = $new_fee;
//						$temp_group_order->add_fee($new_fee);
							// $temp_group_order->update_fee( integer $item_id, $fee_totals );
							
						$temp_group_order->calculate_totals();
						

			// }	//END if ordini (ordini_query)
								
					// }
					// wp_reset_query();
				
				 
			// // }
			// // wp_reset_query();
			
			// // /*END - LORENZO*/
			
			
			
			
			
			// // // $orderlist = query_posts( array( 'post_type' => 'shop_order' ) );
			// // foreach($orderlist as $order)
			// // {
				
				
				
				// prelevo l'ordine ed i suoi dati
				// $the_order = new WC_Order( $order->ID );
				$the_order = $temp_group_order;
				
				$ele_document = $xml->createElement('Document');
				$ele_documents->appendChild($ele_document);	
				
				$ele_document_type = $xml->createElement('DocumentType', 'C');	// C = ordine cliente
				$ele_document->appendChild($ele_document_type);		
				$ele_document_date = $xml->createElement('Date', (string)date_format(new DateTime($the_order->order_date), 'Y-m-d'));		// danea la vuole nel formato 2010-03-23
				$ele_document->appendChild($ele_document_date);
				$ele_document_number = $xml->createElement('Number',$order->ID);
				$ele_document->appendChild($ele_document_number);
				$ele_document_total = $xml->createElement('Total',$the_order->order_total);
				$ele_document->appendChild($ele_document_total);
				$ele_document_payment_name = $xml->createElement('PaymentName',$the_order->payment_method_title);
				$ele_document->appendChild($ele_document_payment_name);
				$ele_document_comment = $xml->createElement('InternalComment',$the_order->customer_note);
				$ele_document->appendChild($ele_document_comment);
				$ele_document_tax = $xml->createElement('CostAmount', ($the_order->order_tax+$the_order->order_shipping_tax));
				$ele_document->appendChild($ele_document_tax);
		     	$ele_document_include_vat = $xml->createElement('PricesIncludeVat', 'true');
				$ele_document->appendChild($ele_document_include_vat);		
				
				/************ BEGIN DATI CLIENTE ************/
				// NB: non lo valorizzo perchè è il codice cliente di danea che è diverso da questo, allora se vuoto crea l'anagrafica se email non esiste in danea oppure chiede di aggiornare
				/*
				if(isset($the_order->customer_user))
				{
					$ele_customer_code = $xml->createElement('CustomerCode', (string)$the_order->customer_user);
				}
				else
				{
					$ele_customer_code = $xml->createElement('CustomerCode', (string)$the_order->user_id);
				}*/
				// $ele_customer_code = $xml->createElement('CustomerCode', null);
				$gruppo_customer_code = get_field("id_daena", $gruppo->ID);
				$ele_customer_code = $xml->createElement('CustomerCode', $gruppo_customer_code);
				$ele_document->appendChild($ele_customer_code);
				
				// $ele_customer_web_login = $xml->createElement('CustomerWebLogin',null);
				// $ele_document->appendChild($ele_customer_web_login);
				// if(isset($the_order->billing_first_name) || isset($the_order->billing_last_name))
				// {
					// $ele_customer_name = $xml->createElement('CustomerName', (string)$the_order->billing_first_name . " " . (string)$the_order->billing_last_name);
				// }
				// else
				// {
					// $ele_customer_name = $xml->createElement('CustomerName', (string)$the_order->billing_company);
				// }
				// $ele_document->appendChild($ele_customer_name);
				$ele_customer_name = $xml->createElement('CustomerName', (string)$gruppo_title);
				$ele_document->appendChild($ele_customer_name);
				// $ele_customer_address = $xml->createElement('CustomerAddress', trim((string)$the_order->billing_address_1 . " " . (string)$the_order->billing_address_2));
				// $ele_document->appendChild($ele_customer_address);
				// $ele_customer_postcode = $xml->createElement('CustomerPostcode', (string)$the_order->billing_postcode);
				// $ele_document->appendChild($ele_customer_postcode);
				// $ele_customer_city = $xml->createElement('CustomerCity', (string)$the_order->billing_city);
				// $ele_document->appendChild($ele_customer_city);
				// $ele_customer_province = $xml->createElement('CustomerProvince', (string)$the_order->billing_state);
				// $ele_document->appendChild($ele_customer_province);
				// $ele_customer_country = $xml->createElement('CustomerCountry', (string)$the_order->billing_country);
				// $ele_document->appendChild($ele_customer_country);		
				// $ele_customer_vatcode = $xml->createElement('CustomerVatCode',null);
				// $ele_document->appendChild($ele_customer_vatcode);
				// $ele_customer_tel = $xml->createElement('CustomerTel', (string)$the_order->billing_phone);
				// $ele_document->appendChild($ele_customer_tel);	
				// $ele_customer_email = $xml->createElement('CustomerEmail', (string)$the_order->billing_email);
				// $ele_document->appendChild($ele_customer_email);
				// $ele_customer_cell = $xml->createElement('CustomerCellPhone',null);
				// $ele_document->appendChild($ele_customer_cell);		
				// $ele_customer_reference = $xml->createElement('CustomerReference',null);
				// $ele_document->appendChild($ele_customer_reference);		
				/************ END DATI CLIENTE ************/


				/************ BEGIN DATI SPEDIZIONE CLIENTE ************/
				if( ($the_order->billing_first_name!=$the_order->shipping_first_name) || ($the_order->billing_last_name!=$the_order->shipping_last_nam) || ($the_order->billing_address_1!=$the_order->shipping_address_1) || ($the_order->billing_address_2!=$the_order->shipping_address_2) || ($the_order->billing_city!=$the_order->shipping_city) || ($the_order->billing_postcode!=$the_order->shipping_postcod) || ($the_order->billing_state!=$the_order->shipping_state))
				{
					$ele_customer_delivery_name = $xml->createElement('DeliveryName', $the_order->shipping_first_name . " " . $the_order->shipping_last_name);
					$ele_document->appendChild($ele_customer_delivery_name);
					$ele_customer_delivery_address = $xml->createElement('DeliveryAddress', trim($the_order->shipping_address_1 . " " . $the_order->shipping_address_2));
					$ele_document->appendChild($ele_customer_delivery_address);
					$ele_customer_delivery_postcode = $xml->createElement('DeliveryPostcode', $the_order->shipping_postcode);
					$ele_document->appendChild($ele_customer_delivery_postcode);
					$ele_customer_delivery_city = $xml->createElement('DeliveryCity', $the_order->shipping_city);
					$ele_document->appendChild($ele_customer_delivery_city);
					$ele_customer_delivery_province = $xml->createElement('DeliveryProvince', $the_order->shipping_state);
					$ele_document->appendChild($ele_customer_delivery_province);
					$ele_customer_delivery_country = $xml->createElement('DeliveryCountry', $the_order->shipping_country);
					$ele_document->appendChild($ele_customer_delivery_country);
				}
				/************ END DATI SPEDIZIONE CLIENTE ************/
				
				
				
				/************ BEGIN PAGAMENTI ************/
				$ele_payments = $xml->createElement('Payments');
				
				$ele_payment = $xml->createElement('Payment');
				$ele_payments->appendChild($ele_payment);
				
				$ele_payment_advance = $xml->createElement('Advance','false');	//Se "true", segnala che il pagamento è riferito ad un acconto
				$ele_payment->appendChild($ele_payment_advance);
				$ele_payment_date = $xml->createElement('Date',null);	
				$ele_payment->appendChild($ele_payment_date);
				$ele_payment_amount = $xml->createElement('Amount',$the_order->order_total);
				$ele_payment->appendChild($ele_payment_amount);
				
				if($the_order->status == 'completed')
				{
					$ele_payment_paid = $xml->createElement('Paid','true');
				}
				else
				{
					$ele_payment_paid = $xml->createElement('Paid','false');
				}
				$ele_payment->appendChild($ele_payment_paid);
				
				
				$ele_document->appendChild($ele_payments);	
				/************ END PAGAMENTI ************/
				
				
				
				/************ BEGIN PRODOTTI ************/
				$ele_prodotti = $xml->createElement('Rows');
				
				$items = $the_order->get_items();
				foreach ( $items as $item )
				{
					$product_name = $item['name'];
				    $product_id = $item['product_id'];
				    $product_qty = round($item['qty'], 3);
					
					
				    $product_variation_id = $item['variation_id'];
					
					$product = get_post( $product_id);
					
					$ele_prodotto = $xml->createElement('Row');
					$ele_prodotti->appendChild($ele_prodotto);					
					
					$ele_prodotto_code = $xml->createElement('Code',$product->_sku);	
					$ele_prodotto->appendChild($ele_prodotto_code);
					$ele_prodotto_description = $xml->createElement('Description',$product->post_title);	
					$ele_prodotto->appendChild($ele_prodotto_description);
					$ele_prodotto_quantita = $xml->createElement('Qty', $product_qty);	
					$ele_prodotto->appendChild($ele_prodotto_quantita);
					if ($item['qty'] ==0){
						$price = "";
					}
					else{
						$price = $item['line_total']/$item['qty'];
					}
					$ele_prodotto_price = $xml->createElement('Price', $price );		// prezzo unitario
					$ele_prodotto->appendChild($ele_prodotto_price);
					
					// Movimentazione magazzino
					$stock_val = get_option('daneawoo_stock', '');
					if($stock_val == "1")
						$ele_prodotto_stock = $xml->createElement('Stock', 'true');
					else
						$ele_prodotto_stock = $xml->createElement('Stock', 'false');		
					$ele_prodotto->appendChild($ele_prodotto_stock);
					
					// COLOR e SIZE	- valutare se parametrizzare il nome dell'attributo che è poi quello che viene usato come nome anche in fase di importazione
					if(isset($product_variation_id))
					{		
						$ele_prodotto_size = $xml->createElement('Size', $item['Taglia']);		
						$ele_prodotto->appendChild($ele_prodotto_size);
						$ele_prodotto_color = $xml->createElement('Color', $item['Colore']);		
						$ele_prodotto->appendChild($ele_prodotto_color);
					}			
					
					$ele_prodotto_vat = $xml->createElement('VatCode', $product->_vat);	
					$ele_prodotto->appendChild($ele_prodotto_vat);
					
				}
				

				$fees = $the_order->get_fees();
				foreach ($fees as $key => $fee ){
					$fee_name = $fee['name'];
					$costo = round($fee['line_total'], 2);
					
//					$gruppo_print .= "<br/><b>TOTALE ".$fee_name.":</b> ".$costo." euro<br/>";
					
					$ele_prodotto = $xml->createElement('Row');
					$ele_prodotti->appendChild($ele_prodotto);					
					
					// $ele_prodotto_code = $xml->createElement('Code',$product->_sku);	
					// $ele_prodotto->appendChild($ele_prodotto_code);
					$ele_prodotto_description = $xml->createElement('Description',$fee_name);	
					$ele_prodotto->appendChild($ele_prodotto_description);
					// $ele_prodotto_quantita = $xml->createElement('Qty', '1');	
					// $ele_prodotto->appendChild($ele_prodotto_quantita);
					$ele_prodotto_price = $xml->createElement('Price', $costo);		// prezzo unitario
					
					$ele_prodotto->appendChild($ele_prodotto_price);
					
					// Movimentazione magazzino
					$stock_val = get_option('daneawoo_stock', '');
					if($stock_val == "1")
						$ele_prodotto_stock = $xml->createElement('Stock', 'true');
					else
						$ele_prodotto_stock = $xml->createElement('Stock', 'false');		
					$ele_prodotto->appendChild($ele_prodotto_stock);
					
					
					$ele_prodotto_vat = $xml->createElement('VatCode', 'FC');	
					$ele_prodotto->appendChild($ele_prodotto_vat);
				}
//				$gruppo_print .= "<b>TOTALE Prodotti: ".$temp_group_order->get_subtotal()." euro<b/><br/>";			
				$gruppo_print .= "<b>TOTALE: ".$temp_group_order->order_total." euro<b/><br/>";			

				salvaMetaDati($gruppo->ID, 'gruppo_print', $gruppo_print);
				// echo $gruppo_print;
				
				$ele_document->appendChild($ele_prodotti);	
				/************ END PRODOTTI ************/
				
				/*
				echo "<br />status order: " . $the_order->status;
				echo "<br />date order: " . $the_order->order_date;
				echo "<br />modified date order: " . $the_order->modified_date;
				echo "<br />customer note: " . $the_order->customer_note;
				echo "<br />order key: " . $the_order->order_key;
				
				$order_number = $the_order->get_order_number();
				echo "<br />order number " . $order_number;
				
				// indirizzo di fatturazione
				echo "<br />billing first name " . $the_order->billing_first_name;
				echo "<br />billing last name " . $the_order->billing_last_name;
				echo "<br />billing company " . $the_order->billing_company;
				echo "<br />billing indirizzo " . $the_order->billing_address_1;
				echo "<br />billing civico " . $the_order->billing_address_2;
				echo "<br />billing city " . $the_order->billing_city;
				echo "<br />billing cap " . $the_order->billing_postcode;
				echo "<br />billing provincia " . $the_order->billing_state;
				echo "<br />billing stato " . $the_order->billing_country;
				echo "<br />billing email " . $the_order->billing_email;
				echo "<br />billing phone " . $the_order->billing_phone;		
				// indirizzo di spedizione
				echo "<br />shipping first name " . $the_order->shipping_first_name;
				echo "<br />shipping last name " . $the_order->shipping_last_name;
				echo "<br />shipping company " . $the_order->shippingg_company;
				echo "<br />shipping indirizzo " . $the_order->shipping_address_1;
				echo "<br />shipping civico " . $the_order->shipping_address_2;
				echo "<br />shipping city " . $the_order->shipping_city;
				echo "<br />shipping cap " . $the_order->shipping_postcode;
				echo "<br />shipping provincia " . $the_order->shipping_state;
				echo "<br />shipping stato " . $the_order->shipping_country;		
				// metodo di spedizione
				echo "<br />shipping metodo " . $the_order->shipping_method;
				echo "<br />shipping metodo descrizione " . $the_order->shipping_method_title;			
				// metodo di pagamento
				echo "<br />payment method" . $the_order->payment_method;
				echo "<br />payment method descrizione " . $the_order->payment_method_title;		
				// prezzi
				echo "<br />order discount " . $the_order->order_discount; 				//  After tax discount total
				echo "<br />cart discount " . $the_order->cart_discount;				//  Before tax discount total
				echo "<br />order tax " . $the_order->order_tax;						// Tax for the items total
				echo "<br />order shipping " . $the_order->order_shipping;				// Shipping cost
				echo "<br />order shipping tax " . $the_order->order_shipping_tax;		// Shipping tax
				echo "<br />order total " . $the_order->order_total;					// Grand total		
				$taxes = $the_order->taxes;					// Taxes array (tax rows)
				if(isset($taxes))	
				{			
					foreach($the_order->taxes as $tax)
					{
						echo "<br />tax " . $tax;
					}
				}			
				// cliente
				echo "<br />customer user " . $the_order->customer_user; // ID cliente
				echo "<br />user id " . $the_order->user_id; // ID utente wordpress		
				// data completamento ordine
				echo "<br />completed date " . $the_order->completed_date; 		
				// status del post
				echo "<br />post status " . $the_order->post_status; 
				
				$items = $the_order->get_items();
				foreach ( $items as $item )
				{
				    $product_name = $item['name'];
				    $product_id = $item['product_id'];
				    $product_variation_id = $item['variation_id'];
					
					echo "<br />product name " . $product_name; 
					echo "<br />product id " . $product_id; 
					echo "<br />product varaition " . $product_variation_id; 
					
					$product = get_post( $product_id);
					
					echo "<br />product id_post " . $product->ID;
					echo "<br />product sku " . $product->_sku;
					echo "<br />product post_name " . $product->post_name;
					echo "<br />product post_content " . $product->post_content;
		      		echo "<br />product quantity " . $item['qty'];
					echo "<br />product total price " . $item['line_total']; // $product->_price;
					echo "<br />product single price " . $item['line_total']/$item['qty'];
					
					$product_terms = wp_get_object_terms($product->ID, 'pa_note');
					if(!empty($product_terms))
					{
					  if(!is_wp_error( $product_terms )){
					    foreach($product_terms as $term){
					      echo "<br />product pa_note " . $term->name; 
					    }
					  }
					}
					
					echo "<br />";
				
				}*/
	
						}	//END if ordini (ordini_query)
					}
					wp_reset_query();
				}

			wp_reset_query();
	
		
			$ele_easyfattDoc->appendChild($ele_documents);	
			/************ BEGIN DOCUMENTS ************/
			
		    $xml->appendChild($ele_easyfattDoc);
			
			
			if(isset($_POST['da_pagina']))
			{
				// die("test");
				//ob_get_flush();
				// ob_clean();
				// //ob_start();
				// header('Content-type: text/xml');
				// header('Content-Disposition: attachment; filename="ordini.xml"');
				//echo $xml->saveXML();
				// file_put_contents(dirname(__FILE__)."/ordini.xml", echo $xml->saveXML());
				file_put_contents(dirname(__FILE__)."/ordini.xml", $xml->saveXML());
				echo '<a href="'.DANEAWOO_URL.'/ordini.xml" target="_blank">Scarica il file ordini.xml</a>';
			}
			else
			{
				echo $xml->saveXML();
			}
			
			die();	
			
			
		}		// chiude if($is_logged)
	
	}	// chiude if(isset($_POST['appver'])
	
	// se appver non è definito, mostro il form per effettuare lo scarico del file direttamente dal web
	else
	{
		?>
		<div class="wrap">
            <div class="icon32"><img src="<?php echo DANEAWOO_URL .'/icone/icona_plugin_danea_woocommerce_32x32.png' ?>" /><br></div>
            <h2>Download ordini</h2>
            <br />
        <?php
		daneawoo_ordini_imposta_valori();
		?>
        	</div>
        <?php
	}
	
}

/******************************************************************************************************************************************************
******************************************************** DANEAWOO - ESPORTAZIONE ORDINI - FINE ********************************************************
******************************************************************************************************************************************************/







/******************************************************************************************************************************************************
******************************************************** DANEAWOO - FUNCTION IMPORT PRODOTTI - INIZIO *************************************************
******************************************************************************************************************************************************/
function importProdotti($file_xml)
{
	$contenuto_file_xml = utf8_encode(file_get_contents($file_xml["tmp_name"]));
	$xml = simplexml_load_string($contenuto_file_xml);
	
	// salvo il file per tenerlo come log di quanto inviato
	/*$percorso_file = ABSPATH . 'wp-content/uploads/tmp' . $file_xml["tmp_name"];
	if(!file_exists(ABSPATH . 'wp-content/uploads/tmp'))
		mkdir(ABSPATH . 'wp-content/uploads/tmp', 0777);
		
	move_uploaded_file( $file_xml["tmp_name"]], $percorso_file);
	*/
	
	$mode = $xml["Mode"];
	
	// DANEA DICE: Quando l'invio � incrementale (vengono trasmessi solo i nuovi prodotti e quelli modificati o cancellati dall'ultima trasmissione), 
	// verranno usate le liste UpdateProducts (per i prodotti da aggiungere o aggiornare) e DeletedProducts (per quelli da eliminare).
	if($mode == "incremental")
	{
		$prodotti_da_aggiornare = count($xml->UpdatedProducts->Product);
		$prodotti_da_cancellare = count($xml->DeletedProducts->Product);
		
		$xml_updated = 	$xml->UpdatedProducts;
		$xml_deleted = $xml->DeletedProducts;
		
		$ret_upd = salvaProdotti($xml_updated);
		$ret_del = cancellaProdotti($xml_deleted);
	}
	// DANEA DICE: Quando l'invio � completo (ovvero vengono trasmessi tutti i prodotti), verr� usata esclusivamente la lista Products. � importante provvedere ad eliminare tutti i prodotti presenti nel database del sito ed assenti nella trasmissione
	else
	{
		
		$prodotti_da_aggiornare = count($xml->Products->Product);
		//die("Mode " . $mode . " - " . $xml->Products);
		
		// cancella i prodotti presenti nel db (NB non tutti i post non presenti ma i post di tipo product (post_type = 'product')
		cancellaTuttiIProdotti();
		
		$xml_updated = 	$xml->Products;
		$ret_upd = salvaProdotti($xml_updated);	
	}

	return $prodotti_da_aggiornare + $prodotti_da_cancellare;
}
/******************************************************************************************************************************************************
******************************************************** DANEAWOO - FUNCTION IMPORT PRODOTTI - FINE *************************************************
******************************************************************************************************************************************************/



function cancellaProdotti($xml_elenco_deleted)
{
	if(!empty($xml_elenco_deleted) || isset($xml_elenco_deleted))
	{
		foreach($xml_elenco_deleted as $xml_elenco_prodotti_todel)
		{ 
			$prodotto =  $xml_elenco_prodotti_todel->Product; 
			foreach($prodotto as $xml_del_product)
			{
			
				$args = array(
					'post_type' => 'product',
					'post_status' => 'any',
					'meta_query' => array(
						array(
							'key' => '_sku',
							'value' => (string)$xml_del_product->Code,
						)
					)
				 );
				$postslist = get_posts( $args );
				foreach($postslist as $post)
				{
					 wp_delete_post($post->ID);
				}
				// if(count($postslist)<=0)
					// die("cancellazione fallita - prodotti non trovati");
			}
		}
	}
}

function cancellaTuttiIProdotti()
{
	$postslist = get_posts( array( 'numberposts' => -1, 'post_status' => 'any', 'post_type' => 'product' ) );
	$count_prodotti = 0;
	$inizio = 0;
	$fine = 0;
	foreach($postslist as $post)
	{
		//$inizio = microtime(true);
		$ret = wp_delete_post($post->ID);		// Set to False if you want to send them to Trash, True for a phisical delete.
		$count_prodotti = $count_prodotti +1;
		//$fine = microtime(true);
		//echo $count_prodotti . " - " . number_format(($fine - $inizio),5,',','.') . "<br />";
		//if(($count_prodotti % 100) == 0)
			//sleep(3);
   	}
	
	// cancello le categorie dei prodotti
	$categories_list = get_categories( array('taxonomy'=> 'product_cat') );
	foreach($categories_list as $cat)
	{
		wp_delete_category($cat->term_id);
	}
	
	return $count_prodotti;
}

function salvaProdotti($xml_upd_products)
{
	//set_time_limit(1800);
	$count_prodotti = 0;
	
	// ATTRIBUTO $article['id'] (es. <article id="1">)
	// VALORE SOTTONODO $article->title (<article id="1"><title>Articolo numero 1</title></article>)	
	foreach($xml_upd_products as $xml_elenco_prodotti)
	{
		//set_time_limit(60);
		$prodotto =  $xml_elenco_prodotti->Product; 
		foreach($prodotto as $xml_upd_product)
		{	
			// salvo la categoria se non esiste, altrimenti la recupero
			// $category_id = (int)salvaCategoriaProdotto(html_entity_decode(mb_convert_encoding($xml_upd_product->Category, 'Windows-1252', 'UTF-8'), ENT_NOQUOTES, 'Windows-1252'), '');
			// $cat_for_prodotto = $category_id;
			
			// se ho una sottocategoria, la salvo se non esiste, altrimenti la recupero
			if(!empty($xml_upd_product->Subcategory))
			{
				// $sub_category_id = salvaCategoriaProdotto(html_entity_decode(mb_convert_encoding($xml_upd_product->Subcategory, 'Windows-1252', 'UTF-8'), ENT_NOQUOTES, 'Windows-1252'), $cat_for_prodotto);
				$sub_category_id = salvaCategoriaProdotto(html_entity_decode(mb_convert_encoding($xml_upd_product->Subcategory, 'Windows-1252', 'UTF-8'), ENT_NOQUOTES, 'Windows-1252'), '');
				$cat_for_prodotto = $sub_category_id;
			}
			
			$descrizione_html = html_entity_decode(mb_convert_encoding((string)$xml_upd_product->DescriptionHtml, 'Windows-1252', 'UTF-8'), ENT_NOQUOTES, 'Windows-1252');
			
			//$descrizione_e_tag = explode("***", (string)$xml_upd_product->DescriptionHtml);
			//$descrizione_html = str_replace("&lt;b&gt;","&lt;strong&gt;",(string)$xml_upd_product->DescriptionHtml);
			//$descrizione_html = str_replace("&lt;/b&gt;","&lt;/strong&gt;",$descrizione_html);
			$descrizione_html = str_replace("<b>","<strong>",(string)$xml_upd_product->DescriptionHtml);
			// $descrizione_html = str_replace("<b>","<strong>",$descrizione_html);
			// $descrizione_html = str_replace("</b>","</strong>",$descrizione_html);
			$descrizione_html = str_replace("&lt;b&gt;","&lt;strong&gt;",(string)$xml_upd_product->DescriptionHtml);
			$descrizione_html = str_replace("&lt;/b&gt;","&lt;/strong&gt;",$descrizione_html);
			$descrizione_html = str_replace("&lt;p&gt;","",$descrizione_html);
			$descrizione_html = str_replace("&lt;/p&gt;","&lt;br/&gt;",$descrizione_html);
			$descrizione_html = str_replace("\r", "",$descrizione_html);
			$descrizione_html = str_replace("\n", "",$descrizione_html);
			
			
			/* Test rimozione per compatibilità layout*/
			// $descrizione_html = str_replace("&nbsp;","<br />",$descrizione_html);
			// $descrizione_html = str_replace("<br/>","",$descrizione_html);
			// $descrizione_html = str_replace("<br>","",$descrizione_html);
			// $descrizione_html = str_replace("&lt;br/&gt;","&nbsp;",$descrizione_html);
			// $descrizione_html = str_replace("&amp;nbsp;","&nbsp;",$descrizione_html);
			// $descrizione_html = str_replace("&rsquo;","'",$descrizione_html);
			
			
			$descrizione_html = html_entity_decode(mb_convert_encoding($descrizione_html, 'Windows-1252', 'UTF-8'), ENT_NOQUOTES, 'Windows-1252');
			$descrizione_per_ricerca_taglie_colori = $descrizione_html;
			$descrizione_html = preg_replace('/\[daneawoo[^\]]*](.*)\[\/daneawoo[^\]]*]/','', $descrizione_html); // preg_replace è una replace con regular expression
			
			/*$descrizione_html = str_replace("�","&agrave;",$descrizione_html);
			$descrizione_html = str_replace("�","&egrave;",$descrizione_html);		
			$descrizione_html = str_replace("�","&igrave;",$descrizione_html);
			$descrizione_html = str_replace("�","&ograve;",$descrizione_html);
			$descrizione_html = str_replace("�","&ugrave;",$descrizione_html);
			*/
			$pos_p = strpos($descrizione_html,"</p>");
			$descrizione_breve = substr($descrizione_html,0,$pos_p+4);
			
			$titolo = html_entity_decode(mb_convert_encoding($xml_upd_product->Description, 'Windows-1252', 'UTF-8'), ENT_NOQUOTES, 'Windows-1252');
			// echo "titolo: ".$titolo."<br>";
						
			// inserisco il prodotto come post
			$post = array(  
			  'comment_status' => 'closed', 												// 'closed' means no comments.
			  'ping_status'    => 'closed', 												// 'closed' means pingbacks or trackbacks turned off
			  'post_author'    => 1, 														//The user ID number of the author.
			  'post_content'   => $descrizione_html, 									//The full text of the post.
			  'post_excerpt'   => $descrizione_breve, 	
			  'post_name'      => str_replace(" ","-", $titolo), 		// The name (slug) for your post  
			  'post_status'    => 'publish', 												//Set the status of the new post.
			  'post_title'     => $titolo, 							//The title of your post.
			  'post_type'      => 'product' 												//You may want to insert a regular post, page, link, a menu item or some custom post type
			);  
			
			$product_id = 0;

			// verifico se il prodotto esiste gia'' usando il meta dato _sku che equivale al Code dell'xml
			$args = array(
				'post_type' => 'product',
				'meta_query' => array(
					array(
						'key' => '_sku',
						'value' => (string)$xml_upd_product->Code,
					)
				)
			 );
			$postslist = get_posts( $args );
			if($postslist)
			{
				foreach($postslist as $post_to_upd)
				{
					$product_id = $post_to_upd->ID;
				}
			}
			// se il prodotto esiste lo modifico
			if($product_id>0)
			{
				// creo un array con l'id del prodotto che mergera' con quello dei dati per passare il tutto alla funzione che salva
				$post_upd = array('ID' => $product_id);
				
				if (!wp_is_post_revision($product_id))
				{
					// unhook this function so it doesn't loop infinitely
					//remove_action('save_post', 'salvaProdotti');
				
					// update the post, which calls save_post again
					wp_update_post(array_merge($post_upd, $post));
			
					// re-hook this function
					//add_action('save_post', 'salvaProdotti');
				}		
			}
			else
			{
				// inserisce il prodotto che e' considerato come un post con post_type = product
				$product_id = wp_insert_post( $post, $wp_error );
			}
			
			// associa la categoria al prodotto
			$ret_cat = wp_set_post_terms( $product_id, array($cat_for_prodotto) ,'product_cat');
			if ( is_wp_error($ret_cat) )
   				echo $ret_cat->get_error_message();			
			
			// imposto il prodotto come visibile
			salvaMetaDati($product_id, '_visibility', 'visible');
			
			// imposto lo sku (Code)
			salvaMetaDati($product_id, '_sku', (string)$xml_upd_product->Code);
	
			// imposto il prezzo "pieno" del prodotto prendendo quale campo selezionare dalle opzioni (GrossPrice4)
			$prezzo = 0;
			switch(get_option('daneawoo_grossprice', ''))
			{
				case "GrossPrice1":
					$prezzo = (float)$xml_upd_product->GrossPrice1;
					break;
				case "GrossPrice2":
					$prezzo = (float)$xml_upd_product->GrossPrice2;
					break;
				case "GrossPrice3":
					$prezzo = (float)$xml_upd_product->GrossPrice3;
					break;
				case "GrossPrice4":
					$prezzo = (float)$xml_upd_product->GrossPrice4;
					break;
				default:
					$prezzo = (float)$xml_upd_product->GrossPrice1;
					break;
			}
			salvaMetaDati($product_id, '_regular_price', (float)$prezzo);
			
			// imposto il prezzo
			salvaMetaDati($product_id, '_price', (float)$prezzo);
			
			// imposto il codice iva
			salvaMetaDati($product_id, '_vat', (float)$xml_upd_product->Vat);
			
			// imposto se e' in magazzino o meno valutando la quantita' disponibile del prodotto ed il valore minimo di stocaggio
			// if($xml_upd_product->AvailableQty > 0 || (isset($xml_upd_product->MinStock) && $xml_upd_product->AvailableQty >= $xml_upd_product->MinStock))
			if(
				$xml_upd_product->AvailableQty > 0
				|| (isset($xml_upd_product->MinStock) && $xml_upd_product->AvailableQty >= $xml_upd_product->MinStock)
				|| ($xml_upd_product->CustomField2=="sempre a richiesta")
				|| ($xml_upd_product->CustomField2>=1)
				)
			{
				salvaMetaDati($product_id, '_stock_status', 'instock');
				$instock=1;
			}
			else
			{
				salvaMetaDati($product_id, '_stock_status', 'outofstock');
				$instock=0;
			}
			
			//imposto codice ordinamento
				salvaMetaDati($product_id, 'codice_ordinamento', (string)$xml_upd_product->CustomField3);
			// imposto unità di misura
				salvaMetaDati($product_id, 'unita_misura', (string)$xml_upd_product->Um);
				
			// imposto unità di vendita
				salvaMetaDati($product_id, 'unita_vendita', (string)$xml_upd_product->CustomField1);
			
			// imposto la quantita' disponibile (AvailableQty)
			if(($xml_upd_product->CustomField2=="solo magazzino")||($xml_upd_product->CustomField2=="sempre a richiesta")||$xml_upd_product->CustomField2==""){
				salvaMetaDati($product_id, '_stock', (int)$xml_upd_product->AvailableQty);
				// echo "AQ:".$xml_upd_product->AvailableQty."<br>";
			}
			else{
				salvaMetaDati($product_id, '_stock', (int)$xml_upd_product->CustomField2);
				// echo "CF2<br>";
			}
			// imposto la proprieta' manage_stock	
			// salvaMetaDati($product_id, '_manage_stock', ((bool)(((bool)$xml_upd_product->ManageWarehouse))&&($xml_upd_product->CustomField2!="sempre a richiesta")));
			$manage_stock="no";
			if((bool)(((bool)$xml_upd_product->ManageWarehouse))&&($xml_upd_product->CustomField2!="sempre a richiesta"))
				$manage_stock="yes";
			salvaMetaDati($product_id, '_manage_stock', $manage_stock);
			
			// imposto la proprieta' _backorders
			salvaMetaDati($product_id, '_backorders', (bool)((((bool)$xml_upd_product->ManageWarehouse))&&($xml_upd_product->CustomField2!="sempre a richiesta")));
			
			// Imposto l'immagine che viene considerata come un post post_type = attachment con con alcuni meta che la descrive (wp_upload_dir e' wp-content/uploads/images/products)
			if(!empty($xml_upd_product->ImageFileName))
			{
				// salvaImmagine($product_id, (string)$xml_upd_product->ImageFileName);
			}
			
			/*imposto il produttore*/
				salvaMetaDati($product_id, 'produttore', (string)$xml_upd_product->SupplierCode);
			
			// cerco il produttore dal codice di SupplierCode
			// $produttore_args = array(
				// 'post_type'  => 'aziende',
				// 'meta_query' => array(
					// array(
						// 'key'     => 'codice_danea',
						// 'value'   => (String)$xml_upd_product->SupplierCode,
					// ),
				// ),
			// );
			// $query_produttore = new WP_Query( $produttore_args );
			
			// if ( $query_produttore->have_posts() )
			// {
				// $query_produttore->the_post();
				// $produttore_id = get_the_ID();
				// wp_reset_postdata();
				// // p2p_type( 'prodotto_azienda' )->connect(
					// // $produttore_id,
					// // $product_id,
					// // array(
						// // 'date' => current_time('mysql'),
					// // )
				// // );
			// }
			
			
			/**************************************************    TAGS    **************************************************/
			// recupero dalle opzioni il campo contenente i tag
			$campo_tags = "";
			switch(get_option('daneawoo_product_tags', ''))
			{
				case "1":
					$campo_tags = $xml_upd_product->CustomField1;
					break;
				case "2":
					$campo_tags = $xml_upd_product->CustomField2;
					break;
				case "3":
					$campo_tags = $xml_upd_product->CustomField3;
					break;
				case "4":
					$campo_tags = $xml_upd_product->CustomField4;
					break;
			}
					
			if(!empty($campo_tags))
			{
				// separo i tags
				$tags = explode(", ", $campo_tags);
				foreach($tags as $tag)
				{
					$cat_id = intval(term_exists($tag, 'pa_valori-aggiunti'));
					if ($cat_id !== 0 && $cat_id !== null)
					{
						$tag = $cat_id;
					}					
				}
				//TODO
				
				// ??????se il tag non essite lo inserisce altrimenti lo recupera e lo associa al prodotto
				
				
				$ret_tag = wp_set_object_terms( $product_id, $tags ,'pa_valori-aggiunti' );
			}
			else
				$ret_tag = wp_set_object_terms( $product_id, '' ,'pa_valori-aggiunti' );
			
			// daneawoo_product_custom_field_1
			// Sono considerati come terms con taxonomy = pa_nomecampo perche' cosi' le ho chiamara in woocommerce -> Attributi 
			$custom_field_1 = get_option('daneawoo_product_custom_field_1', '');
			if(!empty($custom_field_1))
			{
				if(!empty($xml_upd_product->CustomField1))
				{
					$field_1 = html_entity_decode(mb_convert_encoding($xml_upd_product->CustomField1, 'Windows-1252', 'UTF-8'), ENT_NOQUOTES, 'Windows-1252');
					$ret_field_1 = wp_set_object_terms( $product_id, array($field_1), 'pa_' . strtolower($custom_field_1));
					if ( is_wp_error($ret_field_1) )
						echo $ret_field_1->get_error_message();	
						
					$attributes_extra[ sanitize_title('pa_' . strtolower($custom_field_1)) ] = array(
							  'name'          => woocommerce_clean('pa_' . strtolower($custom_field_1)),
							  'value'         => '',
							  'position'      => 0,
							  'is_visible'    => 1,
							  'is_variation'  => 0,
							  'is_taxonomy'   => 1
						  );
				}
			}

			/**************************************************    CUSTOM FIELDS    **************************************************/
			
			// Sono considerati come terms con taxonomy = pa_nomecampo perche' cosi' le ho chiamara in woocommerce -> Attributi
			$custom_field_2 = get_option('daneawoo_product_custom_field_2', '');
			if(!empty($custom_field_2))
			{
				if(!empty($xml_upd_product->CustomField2))
				{
					$field_2 = html_entity_decode(mb_convert_encoding($xml_upd_product->CustomField2, 'Windows-1252', 'UTF-8'), ENT_NOQUOTES, 'Windows-1252');
					$ret_field_2 = wp_set_object_terms( $product_id, array($field_2) , 'pa_' . strtolower($custom_field_2));
					if ( is_wp_error($ret_field_2) )
						echo $ret_field_2->get_error_message();	
						
					$attributes_extra[ sanitize_title('pa_' . strtolower($custom_field_2)) ] = array(
						  'name'          => woocommerce_clean('pa_' . strtolower($custom_field_2)),
						  'value'         => '',
						  'position'      => 1,
						  'is_visible'    => 1,
						  'is_variation'  => 0,
						  'is_taxonomy'   => 1
					  );
				}
			}
			
			// Sono considerati come terms con taxonomy = pa_nomecampo perche' cosi' le ho chiamara in woocommerce -> Attributi
			$custom_field_3 = get_option('daneawoo_product_custom_field_3', '');
			if(!empty($custom_field_3))
			{
				if(!empty($xml_upd_product->CustomField3))
				{
					$field_3 = html_entity_decode(mb_convert_encoding($xml_upd_product->CustomField3, 'Windows-1252', 'UTF-8'), ENT_NOQUOTES, 'Windows-1252');
					$ret_field_3 = wp_set_object_terms( $product_id, array($field_3) ,'pa_' . strtolower($custom_field_3));
					if ( is_wp_error($ret_field_3) )
						echo $ret_field_3->get_error_message();	
					
					$attributes_extra[ sanitize_title('pa_' . strtolower($custom_field_3)) ] = array(
						  'name'          => woocommerce_clean('pa_' . strtolower($custom_field_3)),
						  'value'         => '',
						  'position'      => 2,
						  'is_visible'    => 1,
						  'is_variation'  => 0,
						  'is_taxonomy'   => 1
					  );
				}
			}
			
			// Sono considerati come terms con taxonomy = pa_nomecampo perche' cosi' le ho chiamara in woocommerce -> Attributi
			$custom_field_4 = get_option('daneawoo_product_custom_field_4', '');
			if(!empty($custom_field_4))
			{
				if(!empty($xml_upd_product->CustomField4))
				{
					$field_4 = html_entity_decode(mb_convert_encoding($xml_upd_product->CustomField4, 'Windows-1252', 'UTF-8'), ENT_NOQUOTES, 'Windows-1252');
					$ret_field_4 = wp_set_object_terms( $product_id, array($field_4) ,'pa_' . strtolower($custom_field_4));
					if ( is_wp_error($ret_field_4) )
						echo $ret_field_4->get_error_message();	
					
					$attributes_extra[ sanitize_title('pa_' . strtolower($custom_field_4)) ] = array(
						  'name'          => woocommerce_clean('pa_' . strtolower($custom_field_4)),
						  'value'         => '',
						  'position'      => 3,
						  'is_visible'    => 1,
						  'is_variation'  => 0,
						  'is_taxonomy'   => 1
					  );
					  
					  
				}
			}
			
			// Link: sono cinsiderata come terms con taxonomy = pa_link perch� cos� le ho chiamara in woocommerce -> Attributi
			if(!empty($xml_upd_product->Link))
			{
				$ret_link = wp_set_object_terms( $product_id, array($xml_upd_product->Link) ,'pa_link');
				if ( is_wp_error($ret_link) )
					echo $ret_link->get_error_message();	
					
				$attributes_extra[ sanitize_title('pa_link') ] = array(
					  'name'          => woocommerce_clean('pa_link'),
					  'value'         => '',
					  'position'      => 3,
					  'is_visible'    => 1,
					  'is_variation'  => 0,
					  'is_taxonomy'   => 1
				  );
			}
			
			// Note: sono cinsiderata come terms con taxonomy = pa_note perch� cos� le ho chiamara in woocommerce -> Attributi
			if(!empty($xml_upd_product->Notes))
			{
				$note = html_entity_decode(mb_convert_encoding($xml_upd_product->Notes, 'Windows-1252', 'UTF-8'), ENT_NOQUOTES, 'Windows-1252');
				$note = str_replace("\r\n;","&lt;br/&gt;", $note);
				$ret_note = wp_set_object_terms($product_id, array($note) ,'pa_note');
				if ( is_wp_error($ret_note) )
					echo $ret_note->get_error_message();
					
				$attributes_extra[ sanitize_title('pa_note') ] = array(
					  'name'          => woocommerce_clean('pa_note'),
					  'value'         => '',
					  'position'      => 4,
					  'is_visible'    => 1,
					  'is_variation'  => 0,
					  'is_taxonomy'   => 1
				  );	
			}
				
			
			
			// TODO Gestione taglie e prodotti
			/* <Variant>
				  <Size>M</Size>
				  <Color>Blu</Color>
				  <AvailableQty>23</AvailableQty>
			   </Variant>
			   */
			   
			/* CANCELLO LE VARIAZIONI PRE-ESISTENTI */
			$args_variazioni_to_del = array(
				'post_type' => 'product_variation',
				'post_parent' => $product_id,
			 );
			$postsvariationslist_to_del = get_posts( $args_variazioni_to_del );
			if($postsvariationslist_to_del)
			{
				foreach($postsvariationslist_to_del as $post_variation_to_del)
				{
					wp_delete_post($post_variation_to_del->ID);
				}
			}
			
			// ************** GESTIONE COLORI E TAGLIE *******************
			$num_variazione = 0;
			$taglie = '';
			$colori = '';
				
			if(!empty($xml_upd_product->Variants))
			{
				// guardo quante variazione del prodotto ho
				$variazioni = $xml_upd_product->Variants;
				
				foreach($variazioni->Variant as $variazione)
				{
					// se la variazione ha una quantita' disponibile allora inserico la variazione come product_variation
					if(!empty($variazione->AvailableQty) && (int)$variazione->AvailableQty > 0)
					{
						// controllo se esiste gia' la variazione per il prodotto
						$product_variation_id = 0;
						
						$args_variazioni = array(
							'post_type' => 'product_variation',
							'post_parent' => $product_id,
							'meta_query' => array(
								array(
									'key' => 'attribute_taglia',
									'value' => (string)$variazione->Size
								), array (
									'key' => 'attribute_colore',
									'value' => (string)$variazione->Color,
								)
							)
						 );
						$postsvariationslist = get_posts( $args_variazioni );
						if($postsvariationslist)
						{
							foreach($postsvariationslist as $post_variation_to_upd)
							{
								$product_variation_id = $post_variation_to_upd->ID;
							}
						}
						
						// CREAZIONE VARIAZIONE
						// se la variazione del prodotto non esiste la inserisco come un post con post_type = product_variation
						$product_variation_id = creaVariazioneProdotto($product_id, $product_variation_id, $num_variazione);
						$num_variazione = $num_variazione +1;

						// imposto la quantita' disponibile (AvailableQty)
						salvaMetaDati($product_variation_id, '_stock', (int)$variazione->AvailableQty);
						
						// imposto la taglia (Size)
						salvaMetaDati($product_variation_id, 'attribute_taglia', (string)$variazione->Size);
						
						// imposto il colore (Color)
						salvaMetaDati($product_variation_id, 'attribute_colore', (string)$variazione->Color);

						// imposto il Barcode (Barcode)
						salvaMetaDati($product_variation_id, 'attribute_variazione_barcode', (string)$variazione->Barcode);
						
						// imposto il prezzo "pieno" del prodotto (GrossPrice4) preso dal prodotto perch� Danea non permette di impostarlo diverso
						salvaMetaDati($product_variation_id, '_regular_price', (float)$prezzo);
						
						// imposto il prezzo preso dal prodotto perche' Danea non permette di impostarlo diverso
						salvaMetaDati($product_variation_id, '_price', (float)$prezzo);
	
						// salvo tutte le stringhe taglie e colori disponibili per inserirle come attributi nel post padre
						if(!empty($variazione->Size))
						{
							if($taglie != '')
							{
								$pos_taglia = strpos($taglie, (string)$variazione->Size);
								if ($pos_taglia === false)
									$taglie =  $taglie . "|" . (string)$variazione->Size;
							}
							else
								$taglie = $taglie . (string)$variazione->Size;
						}
						
						if(!empty($variazione->Color))
						{
							if($colori != '')
							{
								$pos_colore = strpos($colori, (string)$variazione->Color);
								if ($pos_colore === false)
									$colori = $colori. "|" . (string)$variazione->Color;
							}
							else
								$colori = $colori . (string)$variazione->Color;
						}
						
						// aggiungo il meta dato che identifica questa coppie taglia colore come predefinita
						if($num_variazione==1)
						{
							$attributes_default = array(
							  'taglia'          => (string)$variazione->Size,
							  'colore'         => (string)$variazione->Color  
							);

							update_post_meta( $product_id, '_default_attributes', $attributes_default );
						}
					}
				}	// chiude foreach variazioni
				
			}	// chiude Variant
			
			// ************** GESTIONE COLORI E TAGLIE - DA DESCRIZIONE HTML *******************
			// provo a vedere se nella descrizione del prodotto è stato inserito uno schortcode che gestisce le taglie del tipo [daneawoo taglie="S|M|L" colori="Azzurro|Rosso" quantità="4"][daneawoo taglie="L" colori="Bianco" quantità="1"]
			preg_match_all('/\[daneawoo[^\]]*](.*)\[\/daneawoo[^\]]*]/',$descrizione_per_ricerca_taglie_colori,$matches); // $matches[0][0]: matrice con tutti gli shortcode presenti $matches[0][1]: shortcode successivo
			
			// in $matches[0][0] c'è [daneawoo taglie="S|M" colori="Blu|Rosso" quantita=5][/daneawoo]
			for ($i=0; $i < count($matches); $i++)
			{
				for ($j=0; $j < count($matches[$i]); $j++)
				{
					preg_match_all('/".*?"/', $matches[$i][$j], $matchesTaglieColori);
					
					$quantitaDaDescr = str_replace("\"","",$matchesTaglieColori[0][2]); // "5" -> 5
					$taglieDaDescr = split("\|",str_replace("\"","",$matchesTaglieColori[0][0]));	// "S|M" -> S M
					$coloriDaDescr = split("\|",str_replace("\"","",$matchesTaglieColori[0][1])); // "Blu|Bianco" -> Blu Bianco
						
					if(!empty($quantitaDaDescr) && (int)$quantitaDaDescr > 0)
					{
						foreach($taglieDaDescr as $tagliaDaDescr)
						{
							if(!empty($tagliaDaDescr))
							{
								foreach($coloriDaDescr as $coloreDaDescr)
								{
									if(!empty($coloreDaDescr))
									{
										// controllo se esiste gia' la variazione per il prodotto
										$product_variation_id = 0;
										
										$args_variazioni = array(
											'post_type' => 'product_variation',
											'post_parent' => $product_id,
											'meta_query' => array(
												array(
													'key' => 'attribute_taglia',
													'value' => (string)$tagliaDaDescr
												), array (
													'key' => 'attribute_colore',
													'value' => (string)$coloreDaDescr,
												)
											)
										 );
										$product_variation_id = 0;
										$postsvariationslist = get_posts( $args_variazioni );
										if($postsvariationslist)
										{
											foreach($postsvariationslist as $post_variation_to_upd)
											{
												$product_variation_id = $post_variation_to_upd->ID;
											}
										}
										
										$product_variation_id = creaVariazioneProdotto($product_id, $product_variation_id, $num_variazione);
										$num_variazione = $num_variazione +1;
										
										// imposto la quantita' disponibile (AvailableQty)
										salvaMetaDati($product_variation_id, '_stock', (int)$quantitaDaDescr);
										
										// imposto la taglia (Size)
										salvaMetaDati($product_variation_id, 'attribute_taglia', (string)$tagliaDaDescr);
										
										// imposto il colore (Color)
										salvaMetaDati($product_variation_id, 'attribute_colore', (string)$coloreDaDescr);
				
										// imposto il prezzo "pieno" del prodotto (GrossPrice4) preso dal prodotto perch� Danea non permette di impostarlo diverso
										salvaMetaDati($product_variation_id, '_regular_price', (float)$prezzo);
										
										// imposto il prezzo preso dal prodotto perche' Danea non permette di impostarlo diverso
										salvaMetaDati($product_variation_id, '_price', (float)$prezzo);
		
										// salvo tutte le stringhe taglie e colori disponibili per inserirle come attributi nel post padre
										if(!empty($tagliaDaDescr))
										{
											if($taglie != '')
											{
												$pos_taglia = strpos($taglie, (string)$tagliaDaDescr);
												if ($pos_taglia === false)
													$taglie =  $taglie . "|" . (string)$tagliaDaDescr;
											}
											else
												$taglie = $taglie . (string)$tagliaDaDescr;
										}
										
										if(!empty($coloreDaDescr))
										{
											if($colori != '')
											{
												$pos_colore = strpos($colori, (string)$coloreDaDescr);
												if ($pos_colore === false)
													$colori = $colori. "|" . (string)$coloreDaDescr;
											}
											else
												$colori = $colori . (string)$coloreDaDescr;
										}
							
										// aggiungo il meta dato che identifica questa coppie taglia colore come predefinita
										if($num_variazione==1)
										{
											$attributes_default = array(
											  'taglia'          => (string)$tagliaDaDescr,
											  'colore'         => (string)$coloreDaDescr  
											);
				
											update_post_meta( $product_id, '_default_attributes', $attributes_default );
										}
							
									} // chiude is isempty colore
							
								} // chiude foreach colore
							
							} // chiude if isempty taglia
						} // chiude foreach taglia

					} // chiude if isempty quantita
				} // chiude for count $j
			} // chiude for descrizione_html con taglie colori
			
			
			if( (!empty($taglie)) || (!empty($colori)))
			{
				$ret_note = wp_set_object_terms( $product_id, array('variable') ,'product_type');
			}
						
			// se ci sono taglie e colori li associo al prodotto base come Attributi
			if(!empty($taglie))
			{
				// per attivare la taglia bisogna inserirla tra gli attrubiti del prodotto "padre"
				$attributes_extra[ sanitize_title('Taglia') ] = array(
				  'name'          => woocommerce_clean('Taglia'),
				  'value'         => $taglie,
				  'position'      => 5,
				  'is_visible'    => 1,
				  'is_variation'  => 1,
				  'is_taxonomy'   => 0
				);	
				
				//echo "taglie - 2";
			}
			
			if(!empty($colori))
			{
				// per attivare i colori bisogna intanto inserirli tra gli attrubiti del prodotto "padre"
				$attributes_extra[ sanitize_title('Colore') ] = array(
				  'name'          => woocommerce_clean('Colore'),
				  'value'         => $colori,
				  'position'      => 6,
				  'is_visible'    => 1,
				  'is_variation'  => 1,
				  'is_taxonomy'   => 0
				);	
				//echo "colori - 2";
			}			
			
			
			if(isset($attributes_extra))
			{
				// adesso inserisco l'array degli attributi che sono le informazioni aggiuntive del prodotto dentro la tabella postmeta secondo una codifica che si costruisce da solo
				if(!function_exists('attributes_cmp')) 
				{
					function attributes_cmp($a, $b) 
					{
						if ( $a['position'] == $b['position'] ) return 0;
						return ( $a['position'] < $b['position'] ) ? -1 : 1;
					}
				}
				uasort( $attributes_extra, 'attributes_cmp' );
	
				update_post_meta( $product_id, '_product_attributes', $attributes_extra );
				unset($attributes_extra);	
				unset($colori);	
				unset($taglie);	
			}
			
			$product_description=''
			.';n:'.$count_prodotti
			.';nomep='.$titolo
			.';prod_id='.$product_id
			.';instock='.$instock
			.';manage_stock='.$manage_stock
			.'\n';
			error_log($product_description);
			$count_prodotti = $count_prodotti + 1;
			//if(($count_prodotti % 100) == 0)
			//	sleep(2);
				
			//sleep(1);
			   
		}
	}
	

		
}

// crea per il prodotto indicatto la variazione per le taglie/colori
function creaVariazioneProdotto($product_id, $product_variation_id, $num_variazione)
{
	// CREAZIONE VARIAZIONE
	// se la variazione del prodotto non esiste la inserisco come un post con post_type = product_variation
	if($product_variation_id==0)
	{
		if($num_variazione==0)
			$n_var = '';
		else
			$n_var = $num_variazione+1;	
			
		$post_variation_title = 'Variazione ### di '. $titolo;
			
		// inserisco il prodotto come post
		$post_variation = array(  
		  'comment_status' => 'closed', 													// 'closed' means no comments.
		  'ping_status'    => 'closed', 													// 'closed' means pingbacks or trackbacks turned off
		  'post_author'    => 2, 															//The user ID number of the author.	
		  'post_name'      => 'product-' . $product_id . '-variation-' . $n_var, 			// The name (slug) for your post  
		  'post_status'    => 'publish', 													//Set the status of the new post.
		  'post_title'     => $post_variation_title, 										//The title of your post.
		  'post_type'      => 'product_variation',
		  'post_parent'    => $product_id
		);  	
		
		$product_variation_id = wp_insert_post( $post_variation, $wp_error );
		
		$post_variation_upd  = array(
			'ID' => $product_variation_id,
			'post_title'  => str_replace('###', '#' . $product_variation_id,  $post_variation_title)
		); 

		if (!wp_is_post_revision($product_variation_id))
		{
			// imposto il post_titolo definitivo
			wp_update_post($post_variation_upd);
		}	
	}
	
	return $product_variation_id;
}

function salvaImmagine($product_id, $filename)
{
	if(!empty( $filename ))
	{
		$wp_filetype = wp_check_filetype(basename($filename), null );
		
		$prodotto = get_post($product_id);
		$nome_prodotto = $prodotto->post_name;
		$nome_immagine = basename($nome_prodotto) . "." . $wp_filetype['ext'];
	
		// verifico che non ci sia gi� il posto di tipo attachment associato a questo prodotto perch� anvente lo stesso titolo
		$args_img = array(
			'post_type' => 'attachment',
			'post_parent' => $product_id,
			'post_title' => $nome_immagine,
			'guid' => 'images/products/' . '/' . $nome_immagine
		 );
		$postslistimages = get_posts($args_img);
	
		if(!$postslistimages)
		{	
			$attachment = array(
				 'guid' => 'images/products/' . '/' . $nome_immagine, 
				 'post_mime_type' => $wp_filetype['type'],
				 'post_title' => preg_replace('/\.[^.]+$/', '', $nome_immagine),
				 'post_content' => '',
				 'post_status' => 'inherit'
			);
			  
			  // PERCORSO Dove caricare le immagini dei prodotti: http://www.lagallinacubista.it/wp-content/uploads/images/products/
			$attach_id = wp_insert_attachment($attachment, ABSPATH . 'wp-content/uploadsimages/products/'. $nome_immagine, $product_id); 
			  
			// you must first include the image.php file for the function wp_generate_attachment_metadata() to work
			require_once(ABSPATH . 'wp-admin/includes/image.php');
			$attach_data = wp_generate_attachment_metadata( $attach_id,  ABSPATH . 'wp-content/uploads/images/products/' . $nome_immagine );
			wp_update_attachment_metadata( $attach_id, $attach_data );
	  
			// associo il thumbnail al prodotto
			salvaMetaDati($product_id, '_thumbnail_id', $attach_id);	
		}	
	}	
}

// verifica l'esistenza della chiave nei metadati per il prodotto indicato, se non esiste la inserisce altrimenti la aggiorna
function salvaMetaDati($product_id, $meta_key, $meta_value)
{
	update_post_meta($product_id, $meta_key, $meta_value);
}

// verifico se esiste la categoria altrimenti la inserisco
function salvaCategoriaProdotto($category, $category_parent)
{
	// restituisce: 0 if the term does not exist. the term ID if no taxonomy was specified and the term exists. 
	// An array if the pairing exists. (format: array('term_id'=>term id, 'term_taxonomy_id'=>taxonomy id))
	$c_id = term_exists($category, 'product_cat');
	
	if ($c_id == 0 || $c_id == null)
	{
		$cat = array('cat_name' => $category, 'category_description' => $category, 'category_nicename' => str_replace(" ","-", $category), 'category_parent' => $category_parent, 'taxonomy' => 'product_cat');

		// Create the category
		$c_id = wp_insert_category($cat);
		$cat_id = (int)$c_id;
	}
	else
	{
		$cat_id = $c_id['term_id'];
	}
	return $cat_id;	
}

function verificaCredenzialiDanea()
{

	// verifico le credenziali
	if ( (isset($_SERVER["HTTP_X_AUTHORIZATION"])) && base64_decode($_SERVER["HTTP_X_AUTHORIZATION"]) != "") 
	{ 
		$is_logged = autenticaUtenteDanea(base64_decode($_SERVER["HTTP_X_AUTHORIZATION"]));
		if($is_logged)
		{
			return true;
		}
		else
			return false;
	}
	else
		return false;
}

function autenticaUtenteDanea($http_x_authorization)
{
	$username_pw = explode(":", $http_x_authorization);
	$username = $username_pw[0];
	$password = $username_pw[1];
	
	// echo "user: " . $username . "\r\npassword: " . $password;
	$ret_user = wp_authenticate($username, $password);
	if(is_wp_error($ret_user))
		echo "errore autenticazione";
		
	wp_set_current_user($ret_user->ID, $username);
	//echo "\r\nid: " . $ret_user->;
	wp_set_auth_cookie($ret_user->ID);
	do_action('wp_login', $username);

	if( 0 == $ret_user->ID)
	{
		// Not logged in
		return false;
	} 
	else 
	{ 
		// Logged in.
		if(is_super_admin($ret_user->ID))
		{
			return true;
		}
		else
		{
			// non suepr admin
			return false;
		}
		// return true;
	}
}


?>