<?php

/*
| -------------------------------------------------------------------
| Aggiungo style bottone
| -------------------------------------------------------------------
|
| */
function wpb_mce_buttons_2($buttons) {
    array_unshift($buttons, 'styleselect');
    return $buttons;
}
add_filter('mce_buttons_2', 'wpb_mce_buttons_2');

/*
* Callback function to filter the MCE settings
*/

add_filter('tiny_mce_before_init', function ($init_array) {
	$style_formats = array(
		// Each array child is a format with it's own settings
		array(
			'title' => 'Image full width',
			'block' => 'div',
			'classes' => 'full-width',
			'wrapper' => true,
		),
		array(
			'title' => 'Image Boxed',
			'block' => 'div',
			'classes' => 'boxed',
			'wrapper' => true,
		),
		array(
			'title' => 'Image Vertical',
			'block' => 'div',
			'classes' => 'vertical',
			'wrapper' => true,
		),
		array(
			'title' => 'Text small',
			'block' => 'span',
			'classes' => 'txt-sm',
			'exact' => true,
			'wrapper' => true,
		),
		array(
			'title' => 'Text medium',
			'block' => 'span',
			'classes' => 'txt-md',
			'exact' => true,
			'wrapper' => true,
		),
		array(
			'title' => 'Text large',
			'block' => 'span',
			'classes' => 'txt-lg',
			'exact' => true,
			'wrapper' => true,
		),
		array(
			'title' => 'Text XL',
			'block' => 'span',
			'classes' => 'txt-xl',
			'exact' => true,
			'wrapper' => true,
		),
		array(
			'title' => 'Text 2XL',
			'block' => 'span',
			'classes' => 'txt-2xl',
			'exact' => true,
			'wrapper' => true,
		),
		array(
			'title' => 'Text 3XL',
			'block' => 'span',
			'classes' => 'txt-3xl',
			'exact' => true,
			'wrapper' => true,
		),
		array(
			'title' => 'Text 4XL',
			'block' => 'span',
			'classes' => 'txt-4xl',
			'exact' => true,
			'wrapper' => true,
		),
		array(
			'title' => 'Text 5XL',
			'block' => 'span',
			'classes' => 'txt-5xl',
			'exact' => true,
			'wrapper' => true,
		),
		array(
			'title' => 'Text 6XL',
			'block' => 'span',
			'classes' => 'txt-6xl',
			'exact' => true,
			'wrapper' => true,
		),
	);
	// Insert the array, JSON ENCODED, into 'style_formats'
	$init_array['style_formats'] = json_encode($style_formats);
	return $init_array;
}, 10, 1);

/* Carico css lato backend*/
function add_admin_css() {
  wp_register_style('blanka_admin_style', get_template_directory_uri().'/functions/admin/editor-custom-style/css/custom-editor-style.css');
  wp_enqueue_style('blanka_admin_style');
}
add_action( 'admin_head', 'add_admin_css' );

?>
