<?php
if( !function_exists('the_blogpost_json_ld') ){
  function the_blogpost_json_ld($post_id){
    if(!$post_id) {
      global $post;
      $post_id = $post->ID;
    }

    $json_ld = array(
      "@context" => "http://schema.org",
      "@type" => "BlogPosting",
      "name" => get_the_title($post_id),
      "publisher" => array(
        "@type" => "Organization",
        "name" => get_bloginfo('name'),
        "logo" => array(
          "@type" => "ImageObject",
          "url" => get_template_directory_uri().'/dist/images/logo-magnum-life.png',
        ),
      ),
      "datePublished" => get_the_date('Y/m/d'),
      "image" => array(
        "@type" => "ImageObject",
        "url" => get_the_post_thumbnail_url($post_id, 'medium'),
        "height" => "100%",
        "width" => "100%",
      ),
      "headline" => get_the_title($post_id),
      "interactionStatistic" => array(
        array(
          "interactionType" => "http://schema.org/ShareAction",
          "interactionService" => array(
            "@type" => "Website",
            "name" => "Twitter",
            "url" => "http://www.twitter.com"
          ),
        ),
        array(
          "interactionType" => "http://schema.org/ShareAction",
          "interactionService" => array(
            "@type" => "Website",
            "name" => "Facebook",
            "url" => "http://www.facebook.com"
          ),
        ),
          array(
          "interactionType" => "http://schema.org/ShareAction",
          "interactionService" => array(
            "@type" => "Website",
            "name" => "Google Plus",
            "url" => "https://plus.google.com/"
          ),
        ),
      ),
    );
    $json = json_encode($json_ld);
    $output = '<script type="application/ld+json">'.$json.'</script>';
    print($output);
  }
}
