<?php
  $image['placeholder'] = get_the_post_thumbnail_url(get_the_ID(), 'medium');
  $image['default'] = get_the_post_thumbnail_url(get_the_ID(), 'large');
  $image['retina'] = get_the_post_thumbnail_url(get_the_ID(), 'large');
  $intro_extended = get_field('intro_extended');
  $mobile_image = get_field('mobile_image');
?>

<div class="single-standard">
  <div class="container-fluid">
    <div class="row row-padding">
      <div class="col-1 col-sm-3-5">
        <figure class="post-img">
          <img class="img-responsive lazy-blanka <?php if($mobile_image) echo 'mobile-hidden'; ?>"
            src="<?= $image['placeholder'] ?>"
            data-src="<?= $image['default'] ?>"
            data-src-retina="<?= $image['retina'] ?>"
            alt="<?php the_title(); ?>" 
            title="<?php the_title(); ?>" 
            longdesc="<?= get_the_excerpt() ?>"/>

            <?php if($mobile_image):?>
              <img class="img-responsive lazy-blanka <?php if($mobile_image) echo 'mobile-only'; ?>"
                src="<?= $mobile_image['sizes']['medium'] ?>"
                data-src="<?= $mobile_image['sizes']['large'] ?>"
                data-src-retina="<?= $mobile_image['sizes']['large'] ?>"
                alt="<?php the_title(); ?>" 
                title="<?php the_title(); ?>" 
                longdesc="<?= get_the_excerpt() ?>"/>
            <?php endif; ?>
        </figure>
      </div>
      <div class="col-1 col-sm-2-5">
        <header class="intro-header">
          <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
            <h1><?php the_title(); ?></h3>
          </a>
          <hr />
          <time><?php echo get_the_date('d/m/Y'); ?></time>
          <?php get_template_part('inc/teaser/_post-categories');?>
        </header>
        <?php if($intro_extended) echo '<div class="extended-intro">'.$intro_extended.'</div>';?>
        <a class="smooth-scroll custom-underline gold" href="#post-content"><?php _e('Continua a leggere','blanka');?></a>
      </div><!--col-md-4-->
    </div><!--row-->
    <div class="row row-padding">
      <main class="col-1 col-sm-4-5">
        <div id="post-content" class="text-wrapper">
          <?php the_content(); ?>
        </div><!--text-wrapper-->
      </main><!--col-->
      <aside class="col-1 col-sm-1-5" id="sidebar">
        <?php get_template_part('inc/related/_related','products-in-post');?>
      </aside><!--col-->
    </div><!--row-->
      <?php
        $post_tags = get_the_tags();
        if ( $post_tags ) {
          echo '<div class="row">';
            echo '<ul class="tag-list">';
            foreach( $post_tags as $tag ) {
              echo '<li>'.$tag->name.'</li>';
            }
            echo '</ul>';
          echo '</div>';
        }
      ?>
    <div class="row">
      <?php get_social_share();?>
    </div>
    <hr />
    <?php get_template_part('inc/related/_related','posts');?>
  </div><!--container-->
</div><!--single-standard-->

<?php if( function_exists('the_blogpost_json_ld') ):
  the_blogpost_json_ld($post->ID);
endif; ?>
