<?php
$image['placeholder'] = get_the_post_thumbnail_url(get_the_ID(), 'placeholder');
$image['default'] = get_the_post_thumbnail_url(get_the_ID(), 'medium');
$image['retina'] = get_the_post_thumbnail_url(get_the_ID(), 'large');
$price = get_field('price');
$weight = get_field('weight');
?>

<article id="<?= get_the_ID() ?>" <?php post_class('lingotto-teaser'); ?> <?php //echo 'data-weight="'.$weight.'" data-price="'.$price.'"';?>>
  <figure>
    <img class="lazy-blanka" src="<?= $image['placeholder'] ?>" data-src="<?= $image['default'] ?>" data-src-retina="<?= $image['retina'] ?>"
    alt="<?php the_title(); ?>" title="<?php the_title(); ?>" longdesc="<?= get_the_excerpt() ?>" />
  </figure>
  <div class="content">
    <header>
      <h3><?php the_title(); ?></h3>
    </header>
    <!-- <div class="excerpt"> -->
      <?php //the_excerpt(); ?>
    <!-- </div> -->
    <?php if($price):?>
      <strong class="pricing">€ <?= get_lingotto_price($price, $weight) ?></strong>
    <?php endif;?>
    <a href="#" class="boxed btn btn-primary"><span><?php _e("Prenota", "blanka"); ?></span></a>
  </div>
</article><!--post-class-->

<?php if( function_exists('the_blogpost_json_ld') ):
  the_blogpost_json_ld($post->ID);
endif; ?>
