<?php
  $left_link = get_field('panel_link_sx', 'option');
  $left_img = get_field('panel_img_sx', 'option');
  $right_link = get_field('panel_link_dx', 'option');
  $right_img = get_field('panel_img_dx', 'option');

  $categories = get_terms( ['taxonomy' => 'product_cat'] );
?>

<div id="shop-panel">
  <div class="inner-wrapper">
    <?php if(!empty($categories)): ?>
    <ul id="sub-menu" class="dropmenu">
      <?php
        // $args = array(
        //   'theme_location' => 'sub-menu',
        //   'menu_class' => 'dropmenu',
        //   'fallback_cb' => '',
        //   'menu_id' => 'sub-menu',
        // );
        // wp_nav_menu($args);
        foreach($categories as $category):
          $cat_id = $category->term_id;
          $thumbnail_id = get_woocommerce_term_meta( $cat_id, 'thumbnail_id', true );
          $cat_image_url = wp_get_attachment_image_src( $thumbnail_id, 'full_hd' );
          $cat_link = get_term_link( $cat_id, 'product_cat' );

        ?>
        <?php if(!get_field('hide_menu', $category)):?>
          <li>
            <a href="<?= $cat_link ?>" title="<?= $category->name ?>">
              <?= $category->name ?>
              <span data-img="<?= $cat_image_url[0] ?>"></span>
            </a>
          </li>
        <?php endif;?>
      <?php endforeach; ?>
    </ul>
    <?php endif; ?>
    <div class="container-fluid">
      <div class="row row-padding">
        <?php
          $classes = '';
          if($right_link) {
            $classes = 'col-sm-2-3 col-1-1';
          } else {
            $classes = 'col-1-1';
          }
        ?>
        <div class="<?= $classes ?>">
          <div class="panel-block left">
            <a href="<?php echo get_permalink( woocommerce_get_page_id( 'shop' ) );?>">
              <img src="<?php echo $left_img['sizes']['large'];?>" alt="<?= $left_img['alt'] ?>" title="<?= $left_img['alt'] ?>" longdesc="<?= $left_img['description'] ?>"/>
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
