<?php
/**
 * My Addresses
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-address.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$customer_id = get_current_user_id();

if ( ! wc_ship_to_billing_address_only() && wc_shipping_enabled() ) {
	$get_addresses = apply_filters( 'woocommerce_my_account_get_addresses', array(
		'shipping' => __( 'Modifica o aggiungi indirizzo di spedizione', 'blanka' ),
		'billing' => __( 'Modifica o aggiungi indirizzo di fatturazione', 'blanka' ),
	), $customer_id );
} else {
	$get_addresses = apply_filters( 'woocommerce_my_account_get_addresses', array(
		'billing' => __( 'Modifica o aggiungi indirizzo di fatturazione', 'woocommerce' ),
	), $customer_id );
}

?>


<?php if ( ! wc_ship_to_billing_address_only() && wc_shipping_enabled() ) : ?>
	<div class="row woocommerce-Addresses">
<?php endif; ?>

<?php foreach ( $get_addresses as $name => $title ) : ?>

	<div class="row woocommerce-Address address-table">
		<h3 class="personal-area-title small"><?php echo $title; ?></h3>
		<?php $address = apply_filters( 'woocommerce_my_account_my_address_formatted_address', array(
        'first_name'  => get_user_meta( $customer_id, $name . '_first_name', true ),
        'last_name'   => get_user_meta( $customer_id, $name . '_last_name', true ),
        'address_1'   => get_user_meta( $customer_id, $name . '_address_1', true ),
        // 'address_2'   => get_user_meta( $customer_id, $name . '_address_2', true ),
        'city'        => get_user_meta( $customer_id, $name . '_city', true ),
        'state'       => get_user_meta( $customer_id, $name . '_state', true ),
        // 'postcode'    => get_user_meta( $customer_id, $name . '_postcode', true ),
        // 'country'     => get_user_meta( $customer_id, $name . '_country', true )
    ), $customer_id, $name );

		// CUSTOM DUEPER TABLE
    if ( ! $address )
      _e( 'You have not set up this type of address yet.', 'woocommerce' );
    else
			echo '<table class="table-address">';
				echo '<thead>';
					echo '<tr>';
						if($address['first_name'])
							echo '<th>Nome</th>';
						if($address['last_name'])
							echo '<th>Cognome</th>';
						if($address['address_1'])
							echo '<th>Indirizzo</th>';
						if($address['city'])
							echo '<th>Città</th>';
						if($address['state'])
							echo '<th>Nazione</th>';
					echo '<th></th>';
					echo '</tr>';
				echo '</thead>';
				echo '<tr>';
				foreach ($address as $key => $value) {
					echo '<th>'.$value.'</th>';
				}
				echo '<th><a class="custom-underline lined-up" href="'.esc_url( wc_get_endpoint_url( "edit-address", $name ) ).'" class="edit">Modifica</a></th>';
				echo '</tr>';
			echo '</table>';
			?>
			<!-- <a href="#" class="add-new-address custom-underline lined-up"> -->
				<?php //_e('Aggiungi nuovo+','blanka');?>
			<!-- </a> -->
	</div>

<?php endforeach; ?>

<?php if ( ! wc_ship_to_billing_address_only() && wc_shipping_enabled() ) : ?>
	</div>
<?php endif;
