<?php
/* 
WARNING :
  https://theeventscalendar.com/product/wordpress-events-calendar/
    needed
*/

if( !function_exists('the_event_json_ld') && class_exists('tribe-events-page-template') ){
  function the_event_json_ld($post_id){
    if(!$post_id) {
      global $post;
      $post_id = $post->ID;
    }

    $json_ld = array(
      "@context" => "http://schema.org",
      "@type" => "Event",
      "name" => get_the_title($post_id),
      "url" => get_permalink($post_id),
      "startDate" => tribe_community_events_get_start_date($post_id),
      "endDate" => tribe_community_events_get_end_date($post_id),
      "description" => the_excerpt($post_id),
      "image" => array(
        "@type" => "ImageObject",
        "url" => get_the_post_thumbnail_url($post_id, 'medium'),
        "height" => "100%",
        "width" => "100%",
      ),
      "offers" => array(
        "@type" => "AggregateOffer",
        "lowPrice" => tribe_get_cost($post_id),
      ),
      "location" => array(
        "@type" => "Place",
        "name" => tribe_get_venue_single_line_address($post_id, false),
        "address" => tribe_get_venue_single_line_address($post_id, false),
      )
    );
    $json = json_encode($json_ld);
    $output = '<script type="application/ld+json">'.$json.'</script>';
    print($output);
  }
}
