<?php

// SVG IN media
function cc_mime_types($mimes) {
  $mimes['svg'] = 'image/svg+xml';
  return $mimes;
}
add_filter('upload_mimes', 'cc_mime_types');

if (!function_exists('wp_split_words')) {
    function wp_split_words($text, $num_words = 55)
  {
    $text = wp_strip_all_tags($text);
    /*
         * translators: If your word count is based on single characters (e.g. East Asian characters),
         * enter 'characters_excluding_spaces' or 'characters_including_spaces'. Otherwise, enter 'words'.
         * Do not translate into your own language.
         */
    if (strpos(_x('words', 'Word count type. Do not translate!'), 'characters') === 0 && preg_match('/^utf\-?8$/i', get_option('blog_charset'))) {
      $text = trim(preg_replace("/[\n\r\t ]+/", ' ', $text), ' ');
      preg_match_all('/./u', $text, $words_array_matches);
      $words_array = $words_array_matches[0];
      $sep         = '';
    } else {
      $words_array = preg_split("/[\n\r\t ]+/", $text, -1, PREG_SPLIT_NO_EMPTY);
      $sep         = ' ';
    }
    if (count($words_array) > $num_words) {
      $before = implode($sep, array_slice($words_array, 0, $num_words));
      $after  = implode($sep, array_slice($words_array, $num_words, count($words_array) - 1));
    } else {
      $before = implode($sep, $words_array);
    }
    $results = array(
      'before' => $before,
      'after' => isset($after) ? $after : ''
    );
    return $results;
  }
}


//Add wp_pagenavi bootstrap compatibility
if ( !function_exists('wp_pagenavi_bootstrap')) {
  add_filter( 'wp_pagenavi', 'wp_pagenavi_bootstrap', 10, 2 );
  function wp_pagenavi_bootstrap($html) {
    $out = '';
    //wrap a's and span's in li's
    $out = str_replace("<div","",$html);
    $out = str_replace("class='wp-pagenavi'>","",$out);
    $out = str_replace("<a","<li><a",$out);
    $out = str_replace("</a>","</a></li>",$out);
    $out = str_replace("<span","<li><span",$out);
    $out = str_replace("</span>","</span></li>",$out);
    $out = str_replace("</div>","",$out);
      $out = str_replace("<li><span class='current'>","<li class='active'><span>",$out);

    return '<div class="text-center"><ul class="pagination pagination-centered">'.$out.'</ul></div>';
  }
}

// Remove additional profile info
if (!function_exists('dueper_remove_profile_fields')) {
  add_filter('user_contactmethods','dueper_remove_profile_fields', 10, 2);
  function dueper_remove_profile_fields( $contactmethods ) {
    unset($contactmethods['aim']);
    unset($contactmethods['jabber']);
    unset($contactmethods['yim']);
    return $contactmethods;
  }
}

// Add featured image in RSS
if ( !function_exists('dueper_rss_post_thumbnail')) {
  add_filter('the_excerpt_rss', 'dueper_rss_post_thumbnail', 10, 2);
  add_filter('the_content_feed', 'dueper_rss_post_thumbnail', 10, 2);
  function dueper_rss_post_thumbnail($content) {
    global $post;
    if(has_post_thumbnail($post->ID)) :
      $content = '<p>' . get_the_post_thumbnail($post->ID) .
      '</p>' . get_the_content();
    endif;
    return $content;
  }
}

// Revising Default Excerpt
if ( !function_exists('bootstrapwp_excerpt')) {
  add_filter('excerpt_more', 'bootstrapwp_excerpt', 10, 2);
  function bootstrapwp_excerpt($more) {
    global $post;
    return '...';
  }
}

add_action('wp_head', function () {
  wp_deregister_style('font-awesome'); // WooCommerce Blocks
  wp_dequeue_style('font-awesome'); // WooCommerce Blocks
  wp_deregister_style('wp-block-library'); // WooCommerce Blocks
  wp_dequeue_style('wp-block-library'); // WooCommerce Blocks
  wp_deregister_style('wc-blocks-vendors-style'); // WooCommerce Blocks
  wp_dequeue_style('wc-blocks-vendors-style'); // WooCommerce Blocks
  wp_deregister_style('wc-blocks-style'); // WooCommerce Blocks
  wp_dequeue_style('wc-blocks-style'); // WooCommerce Blocks
  wp_deregister_style('duplicate-post'); // WooCommerce Blocks
  wp_dequeue_style('duplicate-post'); // WooCommerce Blocks
}, 11);

add_action('wp_enqueue_scripts', function () {
  wp_deregister_style('font-awesome'); // WooCommerce Blocks
  wp_dequeue_style('font-awesome'); // WooCommerce Blocks
  wp_deregister_style('wp-block-library'); // WooCommerce Blocks
  wp_dequeue_style('wp-block-library'); // WooCommerce Blocks
  wp_deregister_style('wc-blocks-vendors-style'); // WooCommerce Blocks
  wp_dequeue_style('wc-blocks-vendors-style'); // WooCommerce Blocks
  wp_deregister_style('wc-blocks-style'); // WooCommerce Blocks
  wp_dequeue_style('wc-blocks-style'); // WooCommerce Blocks
  wp_deregister_style('duplicate-post'); // WooCommerce Blocks
  wp_dequeue_style('duplicate-post'); // WooCommerce Blocks
}, 11);


// Localize admin-ajax
if ( !function_exists('frontend_enqueued_scripts')) {
function frontend_enqueued_scripts() {
    wp_localize_script( 'custom', 'ajax_posts', array(
        'ajaxurl' => admin_url( 'admin-ajax.php' ),
        'noposts' => __('No older posts found', 'blanka'),
    ));
  }
  add_action( 'wp_enqueue_scripts', 'frontend_enqueued_scripts' );
}

//Wrap oEmbed with container
function oembed_wrapper($html, $url, $attr, $post_id) {
  return "<div class='video-responsive'>{$html}</div>";
}
add_filter('embed_oembed_html','oembed_wrapper',10,3);

// helps you to add the custom font to your tinyMCE editor.
function kv_show_font_selector($buttons) {

	$buttons[] = 'fontselect';

	return $buttons;
}
add_filter('mce_buttons_2', 'kv_show_font_selector');

function kv_add_google_webfonts_to_editor() {
    $font_url = 'https://fonts.googleapis.com/css2?family=Cormorant+Garamond:wght@600&family=Poppins:wght@300;500&display=swap';
    add_editor_style( str_replace( ',', '%2C', $font_url ) );
}
add_action( 'init', 'kv_add_google_webfonts_to_editor' );
//
// function kv_custom_font_includion() {
//     add_editor_style( 'css/kv_font.css' );
// }
// add_action( 'init', 'kv_custom_font_includion' );

function kv_custom_font_list($in){
	$in['font_formats']='Cormorant=Cormorant+Garamond;Poppins=Poppins;' ;
 return $in;
}
add_filter('tiny_mce_before_init', 'kv_custom_font_list' );

// Add Language selector in menu
if(function_exists('icl_get_languages') && !function_exists('custom_lang_selector')){
  function custom_lang_selector() {
    $languages = icl_get_languages('skip_missing=0&orderby=code');

    if($languages):
      $container = '<ul class="lang-menu">';
      $items = '';
      foreach($languages as $l) :
        if(!$l['active']) :
          $items .= '<li class="menu-item-language"><a href="'.$l['url'].'">'.$l['code'].'</a></li>';
        else :
          $container .= '<li class="menu-item-language active"><a href="'.$l['url'].'">'.$l['code']. '</a><span class="divider"> |  </span>';
        endif;
      endforeach;
      $html = $container . $items;
      $html .= '</li></ul><span class="divider"> | </span>';
    endif;

    return $html;
  }
}


// DELETE POST THUMB WHEN DELETING POSTS
add_action( 'before_delete_post', 'delete_product_images', 10, 1 );

function delete_product_images( $post_id )
{
    $product = wc_get_product( $post_id );

    if ( !$product ) {
        return;
    }

    $featured_image_id = $product->get_image_id();
    $image_galleries_id = $product->get_gallery_image_ids();

    if( !empty( $featured_image_id ) ) {
        wp_delete_post( $featured_image_id );
    }

    if( !empty( $image_galleries_id ) ) {
        foreach( $image_galleries_id as $single_image_id ) {
            wp_delete_post( $single_image_id );
        }
    }
}

// AJAX LOAD MORE
// add_action( 'wp_ajax_load_more_posts', 'load_more_posts' );
// add_action( 'wp_ajax_nopriv_load_more_posts', 'load_more_posts' );
//  function load_more_posts(){
//    global $post;
//    $args = array('post_type'=>'post', 'posts_per_page'=> 6, 'offset'=> $_POST['offset']);
//    $rst=[];
//    $query = new WP_Query($args);
//    if($query->have_posts()):
//        while($query->have_posts()):$query->the_post();
//            $rst[] = $post;
//        endwhile;
//        wp_reset_postdata();
//        $offset = $_POST['offset']+6;
//    endif;
//    wp_send_json_success(array('post'=>$rst, 'offset'=>$offset));
//  }

/**
 * Change number of products that are displayed per page (shop page)
 */

// SEO Custom settings 

function globale_seo_settings() {
  $meta_tag_author = get_field('meta_tag_author', 'option');
  $meta_tag_keywords = get_field('meta_tag_keywords', 'option');

  if($meta_tag_author) {
    echo '<meta name="author" content="'.$meta_tag_author.'" />';
  }
  if($meta_tag_keywords) {
    echo '<meta name="keywords" content="'.$meta_tag_keywords.'" />';
  }
}
add_action('wp_head', 'globale_seo_settings');