<?php
/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.3.2
 */

defined( 'ABSPATH' ) || exit;

// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if ( ! function_exists( 'wc_get_gallery_image_html' ) ) {
	return;
}

global $product;

$columns           = apply_filters( 'woocommerce_product_thumbnails_columns', 4 );
$post_thumbnail_id = $product->get_image_id();
$wrapper_classes   = apply_filters( 'woocommerce_single_product_image_gallery_classes', array(
	'woocommerce-product-gallery',
	'woocommerce-product-gallery--' . ( has_post_thumbnail() ? 'with-images' : 'without-images' ),
	'woocommerce-product-gallery--columns-' . absint( $columns ),
	'images',
) );

$images = $attachment_ids = array();
$product_image = $product->get_image_id();
if (!empty($product_image)) {
	$attachment_ids[] = $product_image;
}
$attachment_ids = array_merge($attachment_ids, $product->get_gallery_image_ids());

?>
<div class="<?php echo esc_attr( implode( ' ', array_map( 'sanitize_html_class', $wrapper_classes ) ) ); ?>" data-columns="<?php echo esc_attr( $columns ); ?>" style="opacity: 0; transition: opacity .25s ease-in-out;">
	<figure class="woocommerce-product-gallery__wrapper">
		<?php if(!empty($attachment_ids)):?>
			<?php foreach( $attachment_ids as $attachment_id ):?>
				<?php
					$image = wp_get_attachment_image_src( $attachment_id, 'large' );
					$thumb = wp_get_attachment_image_src( $attachment_id, 'thumbnail' );
				?>
				<a 
					href="<?php echo $image[0];?>"
					data-caption="<?php echo get_the_title();?>"
					data-fancybox="gallery-<?php echo get_the_ID();?>"
				>
					<img src="<?php echo $image[0];?>"/>
				</a>
			<?php endforeach;?>
		<?php endif;?>
	</figure>
</div>
