<?php
/**
 * Template Name: Blog
 * This template is used for display frontpage
 *
 * @author Dueper Design
 * @package Dueper Theme
 */
get_header();
while ( have_posts() ) : the_post(); ?>

<header class="page-header">
  <?php the_title('<h1 class="page-title">','</h1>');?>
</header>

<?php
$main_args = array(
  'post_type'=>'post',
  'posts_per_page'  => 1
);
$main_posts = new WP_Query($main_args);
if ($main_posts->have_posts()) :
  echo '<div class="container-fluid">';
    while($main_posts->have_posts()) : $main_posts->the_post();
      get_template_part('inc/teaser/_teaser-post', 'full');
      $exclude_posts[] = $post->ID;
    endwhile;
  echo '</div><!--container-->';
endif;
wp_reset_query();?>

<div class="separator">
  <div class="container-fluid">
    <div class="row row-padding">
      <div class="col-1-1 col-sm-3-4">
        <div class="separator-wrapper">
          <h3 class="separator-title"><?php _e('News recenti','blanka');?></h3>
        </div>
      </div>
      <div class="col-1-1 col-sm-1-4 hidden-mobile">
        <div class="separator-wrapper">
          <h3 class="separator-title"><?php _e('Categorie','blanka');?></h3>
        </div>
      </div>
    </div>
  </div>
</div>

<?php
// $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
$news_args = array(
  'post_type'=>'post',
  'post__not_in' => $exclude_posts,
  'posts_per_page'  => 6,
  // 'paged' => $paged
);
$news_posts = new WP_Query($news_args);
  echo '<div class="container-fluid">';
    echo '<div class="row row-padding">';
    if ($news_posts->have_posts()) :
      echo '<main class="col-1-1 col-sm-3-4">';
        echo '<div class="row row-padding loop">';
          while($news_posts->have_posts()) : $news_posts->the_post();
            echo '<div class="col-1-1 col-sm-1-2">';
              get_template_part('inc/teaser/_teaser-post');
            echo '</div><!--col-->';
          endwhile;
        echo '</div><!--row-->';
        // * LOAD MORE *
        $shortcode_params = '
          transition_container="false"
          container_type="div"
          css_classes="row row-padding loop"
          post_type="post"
          button_label="Carica altri articoli"
          button_loading_label="Caricamento..."
          images_loaded="true"
          offset="7"
          posts_per_page="6"
          scroll="false"
          pause="true"
          ';
          // var_dump($shortcode_params);
        echo do_shortcode('[ajax_load_more '.$shortcode_params.']');
      echo '</main><!--col-->';
    endif;
      echo '<aside class="col-1-1 col-sm-1-4 hidden-mobile">';
        get_template_part('inc/sidebar/_category-list');
      echo '</aside><!--col-->';
    echo '</div><!--row-->';
  echo '</div><!--container-->';
wp_reset_query();?>


<script>
jQuery(document).ready(() => {
  var sticky = new Sticky('.menu-container');
})
</script>

<?php endwhile;
get_footer(); ?>
