<?php

/**
 * Simple product add to cart
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/add-to-cart/simple.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined('ABSPATH') || exit;

global $product;

if (!$product->is_purchasable()) {
	return;
}

echo wc_get_stock_html($product); // WPCS: XSS ok.

$text_button_offer = get_field('text_button_offer','option');
$cta_worn_product = get_field('cta_worn_product','option');

if ($product->is_in_stock()) : ?>

	<?php do_action('woocommerce_before_add_to_cart_form'); ?>

	<form class="cart" action="<?php echo esc_url(apply_filters('woocommerce_add_to_cart_form_action', $product->get_permalink())); ?>" method="post" enctype='multipart/form-data'>
		<?php do_action('woocommerce_before_add_to_cart_button'); ?>

		<?php
		do_action('woocommerce_before_add_to_cart_quantity');

		woocommerce_quantity_input(array(
			'min_value'   => apply_filters('woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product),
			'max_value'   => apply_filters('woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product),
			'input_value' => isset($_POST['quantity']) ? wc_stock_amount(wp_unslash($_POST['quantity'])) : $product->get_min_purchase_quantity(), // WPCS: CSRF ok, input var ok.
		));

		do_action('woocommerce_after_add_to_cart_quantity');
		?>
	<div class="add-to-cart-container">
		<button type="submit" name="add-to-cart" value="<?php echo esc_attr($product->get_id()); ?>" class="single_add_to_cart_button buy-now-button button alt" id="buy_now_button">
			<?php _e('Buy Now','blanka'); ?>
		</button>
		<div class="buy-wrapper">
			<button type="submit" name="add-to-cart" value="<?php echo esc_attr($product->get_id()); ?>" class="cart-button"><?php echo esc_html($product->single_add_to_cart_text()); ?></button>
			<div class="btn-product-offer"><span><?php echo $text_button_offer; ?></span></div>
		</div>
	</div>
		<input type="hidden" name="is_buy_now" id="is_buy_now" value="0" />
		<div class="cta-worn-product"><?php echo $cta_worn_product; ?></div>
		<?php do_action('woocommerce_after_add_to_cart_button'); ?>
	</form>

	<div class="book-gold-popup offer-popup">
		<div class="inner-wrapper">
			<div class="close-overlay"><i class="icon-cross"></i></div>
			<?php
				$form = get_field('offer_form','option');
				gravity_form($form['id'], true, true, true, '', true, 1);
			?>
		</div>
	</div>

	<?php do_action('woocommerce_after_add_to_cart_form'); ?>

<?php endif; ?>