<?php if( have_rows('prod_slider') ): ?>
    <section class="home-section home-products">
        <h3 class="section-title"><?php _e('Scopri i nostri prodotti','blanka'); ?></h3>
        <ul class="product-slides">
            <?php while( have_rows('prod_slider') ): the_row();
                // vars
                $prod = get_sub_field('product');
                // override $post
                $post = $prod;
                setup_postdata( $post );

                if ($post):
                    // Get the product ID
                    $_ID = get_the_ID();
                    // Get the product object
                    $_product = wc_get_product($_ID);

                    // Check if the product is in stock (quantity > 0)
                    if ($_product->get_stock_quantity() > 0):
                        // Proceed to display the product only if it's available in stock
                        $image['placeholder'] = get_the_post_thumbnail_url($_ID, 'placeholder');
                        $image['default'] = get_the_post_thumbnail_url($_ID, 'large');
                        $image['retina'] = get_the_post_thumbnail_url($_ID, 'large');

                        $brand_title = $_product->get_attribute('brand');
                        $price = wc_price($_product->get_regular_price());
                        $price_on_sale = wc_price($_product->get_sale_price());
            ?>
                        <li class="slide">
                            <article <?php post_class('product-teaser'); ?>>
                                <figure class="">
                                    <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                                        <img class="lazy-blanka img-responsive" src="<?= $image['retina'] ?>" data-src="<?= $image['default'] ?>" data-src-retina="<?= $image['retina'] ?>" alt="<?= get_the_title() ?>" title="<?= get_the_title() ?>" longdesc="<?= get_the_title() ?>"/>
                                    </a>
                                </figure>
                                <div class="content">
                                    <header>
                                        <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                                            <h4 class="brand-title">
                                                <?php if($brand_title) echo $brand_title; ?>
                                            </h4>
                                            <h3 class="product-title"><?php the_title(); ?></h3>
                                        </a>
                                    </header>
                                    <?php if($_product->is_on_sale()):
                                        echo '<label class="original-price override">€ '.$price.'</label>';
                                        echo '<label class="sale-price">€ '.$price_on_sale.'</label>';
                                    else:
                                        echo '<label class="original-price">€ '.$price.'</label>';
                                    endif; ?>
                                </div>
                                <div class="clearfix"></div>
                            </article><!--post-class-->

                            <?php if(function_exists('the_blogpost_json_ld')):
                                the_blogpost_json_ld($post->ID);
                            endif; ?>
                        </li>
            <?php
                    endif; // end check for product availability
                endif; // end check for $post
                wp_reset_postdata();
            endwhile; // end product loop
            ?>
        </ul>
    </section>
<?php endif; ?>
