<?php

/**
 * The template for displaying the footer.
 *
 * Contains the closing of the id=main div and all content after
 *
 * @author Dueper Design
 * @package Dueper Theme1
 */
?>

<?php
$blogname = get_bloginfo('site_name');
$iva = get_field('iva', 'option');
$to_top = get_template_directory_uri() . '/dist/images/back-to-top.svg';
?>

<footer class="site-foot" id="main-footer">
  <a id="to-top" class="hidden-xs hidden-sm">
    <img src="<?= $to_top ?>" />
  </a>
  <div class="container-fluid clearfix">
    <div class="row row-padding">
      <div class="col-sm-1-4 col-xs-1-2 col-1-1">
        <?php if (!dynamic_sidebar('footer-one')); ?>
      </div>
      <!--col-sm-1-4 col-xs-1-2-->
      <div class="col-sm-1-4 col-xs-1-2 col-1-1">
        <?php if (!dynamic_sidebar('footer-two')); ?>
      </div>
      <!--col-sm-1-4 col-xs-1-2-->
      <div class="col-sm-1-4 col-xs-1-2 col-1-1">
        <?php if (!dynamic_sidebar('footer-three')); ?>
        <?php if (get_field('facebook', 'option')) : ?>
          <div class="fb-container">
            <label><?php _e('Vieni a trovarci su Facebook', 'blanka'); ?></label>
            <?php echo '<a href="' . esc_url(get_field('facebook', 'option')) . '" target="_blank" title="' . __('Facebook', 'blanka') . '" class="facebook"><span class="icon-facebook"></span></a>'; ?>
          </div>
        <?php endif; ?>
      </div>
      <!--col-sm-1-4 col-xs-1-2-->
      <div class="col-sm-1-4 col-xs-1-2 col-1-1">
        <!-- <input type="mail" placeholder="La tua email">
            <button class="btn btn-primary">Iscriviti</button> -->
        <?php if (!dynamic_sidebar('footer-four')); ?>
      </div>
      <!--col-sm-1-4 col-xs-1-2-->
    </div>
    <!--row-->
  </div>
  <!--container-->
  <div class="credits">
    <?php _e('Ledial S.R.L ', 'blanka'); ?>
    <?php echo '&copy; ' . date('Y'); ?>
    <?php if ($iva) echo 'P.Iva ' . $iva; ?>
    <?php _e(' Milano - MI', 'blanka'); ?>
  </div><!-- .site-info -->
</footer>
</div>
<!--.inner-main-->
</div>
<!--#main-container-->
<?php wp_footer(); ?>

</body>

</html>