<?php
$prod_slider_category = get_field('prod_slider_category');

if ($prod_slider_category) {
    // Ottieni l'ID della categoria
    $category_id = $prod_slider_category->term_id;

    // Crea un array di argomenti per la query
    $args = array(
        'post_type' => 'product',  // Tipo di post "Prodotto" (presumibilmente WooCommerce)
        'posts_per_page' => -1,   // Mostra tutti i prodotti
        'tax_query' => array(
            array(
                'taxonomy' => 'product_cat',  // Taxonomy per le categorie dei prodotti
                'field' => 'id',              // Campo per il confronto (id della categoria)
                'terms' => $category_id,      // ID della categoria da cui recuperare i prodotti
            ),
        ),
    );

    // Esegui la query per ottenere i prodotti della categoria scelta
    $products_query = new WP_Query($args);

    if ($products_query->have_posts()): ?>
        <section class="home-section home-products">
            <h3 class="section-title"><?php _e('Scopri i nostri prodotti', 'blanka'); ?></h3>
            <ul class="product-slides">
                <?php while ($products_query->have_posts()): $products_query->the_post();
                    $_ID = get_the_ID();
                    $_product = wc_get_product($_ID);

                    if ($_product->get_stock_quantity() > 0):
                        // Ottenere le informazioni sui prodotti qui
                        $image['placeholder'] = get_the_post_thumbnail_url($_ID, 'placeholder');
                        $image['default'] = get_the_post_thumbnail_url($_ID, 'large');
                        $image['retina'] = get_the_post_thumbnail_url($_ID, 'large');

                        $brand_title = $_product->get_attribute('brand');
                        $price = wc_price($_product->get_regular_price());
                        $price_on_sale = wc_price($_product->get_sale_price());
                ?>
                        <li class="slide">
                            <article <?php post_class('product-teaser'); ?>>
                                <figure class="">
                                    <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                                        <img class="lazy-blanka img-responsive" src="<?= $image['retina'] ?>" data-src="<?= $image['default'] ?>" data-src-retina="<?= $image['retina'] ?>" alt="<?= get_the_title() ?>" title="<?= get_the_title() ?>" longdesc="<?= get_the_title() ?>" />
                                    </a>
                                </figure>
                                <div class="content">
                                    <header>
                                        <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                                            <h4 class="brand-title">
                                                <?php if ($brand_title) echo $brand_title; ?>
                                            </h4>
                                            <h3 class="product-title"><?php the_title(); ?></h3>
                                        </a>
                                    </header>
                                    <?php if ($_product->is_on_sale()):
                                        echo '<label class="original-price override">€ ' . $price . '</label>';
                                        echo '<label class="sale-price">€ ' . $price_on_sale . '</label>';
                                    else:
                                        echo '<label class="original-price">€ ' . $price . '</label>';
                                    endif; ?>
                                </div>
                                <div class="clearfix"></div>
                            </article><!--post-class-->

                            <?php if (function_exists('the_blogpost_json_ld')):
                                the_blogpost_json_ld($post->ID);
                            endif; ?>
                        </li>
                <?php
                    endif; // Fine del controllo per la disponibilità del prodotto
                endwhile; // Fine del ciclo dei prodotti
                wp_reset_postdata(); // Effettua il reset della query personalizzata
                ?>
            </ul>
        </section>
    <?php
    endif; // Fine del controllo per la presenza di prodotti nella categoria
}
?>
