<?php
  $marker = get_field('marker','option');
  $location = get_field('gmap_coor');
  $address = get_field('indirizzo');
  $contact_1 = get_field('block_1');
  $contact_2 = get_field('block_2');
  $link = get_field('gmap_link');
  $button_one = get_field('button_one');
  $button_two = get_field('button_two');
  $image['placeholder'] = get_the_post_thumbnail_url(get_the_ID(), 'placeholder');
  $image['default'] = get_the_post_thumbnail_url(get_the_ID(), 'medium');
  $image['retina'] = get_the_post_thumbnail_url(get_the_ID(), 'large');
?>

<div class="single-standard">
  <div class="row row-padding">
    <div class="col-1">
      <a class="back-to" href="<?php echo get_post_type_archive_link( 'negozio' ); ?>">
        <i class="icon-chevron-left"></i><?php _e('Torna agli store','blanka');?>
      </a>
      <hr />
      <header class="page-header">
        <figure class="alignfull">
          <img class="lazy-blanka alignfull" src="<?= $image['placeholder'] ?>" data-src="<?= $image['default'] ?>" data-src-retina="<?= $image['retina'] ?>"
      alt="<?php the_title(); ?>" title="<?php the_title(); ?>" alt="<?= $address ?>"/>
        </figure>
        <h1 class="page-title container"><?php the_title(); ?></h1>
      </header>
    </div><!-- col -->
  </div><!--row-->
  <div class="container">
    <div class="row row-padding info-blocks">
      <?php if($link) echo '<a class="btn btn-primary boxed phablet" href="'.$link.'" target="_blank"><span>Visualizza Percorso</span></a>';?>
      <?php if($contact_1 || $contact_2) :?>
        <div class="col-1-1 col-sm-1-2 contact-block">
          <div class="col-1-1 block-title">
            <h5 class="info-title"><?php _e('Contatti','blanka');?></h5>
            <hr />
          </div>
          <div class="row row-padding">
            <?php if($contact_2):?>
              <div class="col-1-1 col-sm-1-2">
                <?= $contact_2 ?>
              </div>
            <?php endif;?>
          </div>
        </div>
      <?php endif; ?>
      <?php if( have_rows('hour_list') ): ?>
        <div class="col-1-1 col-sm-1-2 timing-block">
          <div class="col-1-1">
            <h5 class="info-title"><?php _e('Orari','blanka');?></h5>
            <hr />
          </div>
          <div class="row row-padding">
            <div class="col-1-1">
            	<ul class="timing">

            	<?php while( have_rows('hour_list') ): the_row();

            		// vars
            		$day = get_sub_field('day');
            		$hour = get_sub_field('hour');

            		?>

            		<li class="time-el">
                  <?php if($day) echo '<h6 class="day">'.$day.'</h6>';?>
                  <?php if($hour) echo '<time class="hour">'.$hour.'</time>';?>
            		</li>

            	<?php endwhile; ?>

            	</ul>

            </div><!-- col -->
          </div><!-- row -->
        </div><!-- col -->
      <?php endif; ?>
    </div><!-- row -->

    <?php if($button_one || $button_two) :?>
      <div class="row row-padding button-wrapper">
        <?php if($button_one) :?>
          <a href="<?php echo $button_one['url'] ?>" target="<?php echo $button_one['target'] ?>">
            <button>
              <?php echo $button_one['title'] ?>
            </button>
          </a>
        <?php endif; ?>

        <?php if($button_two) :?>
          <a href="<?php echo $button_two['url'] ?>" target="<?php echo $button_two['target'] ?>">
            <button>
              <?php echo $button_two['title'] ?>
            </button>
          </a>
        <?php endif; ?>
      </div>
    <?php endif; ?>
  </div><!--container-->
    <?php if($link) {
      echo '<div class="row link-wrapper">';
        echo '<div class="col-1-1 col-sm-1-2"></div>';
        echo '<div class="col-1-1 col-sm-1-2"><a class="btn btn-primary boxed desktop" href="'.$link.'" target="_blank"><span>Visualizza Percorso</span></a></div>';
      echo '</div>';
    } ?>
  </div><!-- container -->
</div><!--single-standard-->

<script>
  jQuery(document).ready(function() {
    render_map(jQuery('.map-container'))
  })
</script>
<?php if( function_exists('the_blogpost_json_ld') ):
  the_blogpost_json_ld($post->ID);
endif; ?>
