<?php
$image['placeholder'] = get_the_post_thumbnail_url(get_the_ID(), 'placeholder');
$image['default'] = get_the_post_thumbnail_url(get_the_ID(), 'large');
$image['retina'] = get_the_post_thumbnail_url(get_the_ID(), 'large');  
$mobile_image = get_field('mobile_image');
?>

<article <?php post_class('post-teaser'); ?>>
 <figure>
    <img class="img-responsive lazy-blanka <?php if($mobile_image) echo 'mobile-hidden'; ?>"
      src="<?= $image['placeholder'] ?>"
      data-src="<?= $image['default'] ?>"
      data-src-retina="<?= $image['retina'] ?>"
      alt="<?php the_title(); ?>" 
      title="<?php the_title(); ?>" 
      longdesc="<?= get_the_excerpt() ?>"/>

      <?php if($mobile_image):?>
        <img class="img-responsive lazy-blanka <?php if($mobile_image) echo 'mobile-only'; ?>"
          src="<?= $mobile_image['sizes']['medium'] ?>"
          data-src="<?= $mobile_image['sizes']['large'] ?>"
          data-src-retina="<?= $mobile_image['sizes']['large'] ?>"
          alt="<?php the_title(); ?>" 
          title="<?php the_title(); ?>" 
          longdesc="<?= get_the_excerpt() ?>"/>
      <?php endif; ?>
  </figure>
  <div class="content">
    <header>
      <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
        <h3><?php the_title(); ?></h3>
      </a>
      <hr />
      <time><?php echo get_the_date('d/m/Y'); ?></time>
      <?php get_template_part('inc/teaser/_post-categories');?>
    </header>
    <div class="excerpt">
      <?php the_excerpt(); ?>
    </div>
    <a href="<?php the_permalink(); ?>" class="custom-underline lined-up gold"><?php _e("Leggi l'articolo", "blanka"); ?></a>
  </div>
</article><!--post-class-->

<?php if( function_exists('the_blogpost_json_ld') ):
  the_blogpost_json_ld($post->ID);
endif; ?>
