/* eslint-disable */
var $ = jQuery;

$(window).on('load', () => {
    // const google = window.google;

    function render_map($el) {
        // var
        var $markers = $el.find('.marker');
        var styles = [
            {
                "featureType": "water",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#e9e9e9"
                    },
                    {
                        "lightness": 17
                    }
                ]
            },
            {
                "featureType": "landscape",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#ffffff"
                    },
                    {
                        "lightness": 20
                    }
                ]
            },
            {
                "featureType": "road.highway",
                "elementType": "geometry.fill",
                "stylers": [
                    {
                        "color": "#EDE0AC"
                    },
                    {
                        "lightness": 17
                    }
                ]
            },
            {
                "featureType": "road.highway",
                "elementType": "geometry.stroke",
                "stylers": [
                    {
                        "color": "#EDE0AC"
                    },
                    {
                        "lightness": 29
                    },
                    {
                        "weight": 0.2
                    }
                ]
            },
            {
                "featureType": "road.arterial",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#EDE0AC"
                    },
                    {
                        "lightness": 18
                    }
                ]
            },
            {
                "featureType": "road.local",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#EDE0AC"
                    },
                    {
                        "lightness": 16
                    }
                ]
            },
            {
                "featureType": "poi",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#ffffff"
                    },
                    {
                        "lightness": 21
                    }
                ]
            },
            {
                "featureType": "poi.park",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#FBF7EA"
                    },
                    {
                        "lightness": 21
                    }
                ]
            },
            {
                "elementType": "labels.text.stroke",
                "stylers": [
                    {
                        "visibility": "on"
                    },
                    {
                        "color": "#ffffff"
                    },
                    {
                        "lightness": 16
                    }
                ]
            },
            {
                "elementType": "labels.text.fill",
                "stylers": [
                    {
                        "saturation": 36
                    },
                    {
                        "color": "#333333"
                    },
                    {
                        "lightness": 40
                    }
                ]
            },
            {
                "elementType": "labels.icon",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "transit",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#ffffff"
                    },
                    {
                        "lightness": 19
                    }
                ]
            },
            {
                "featureType": "administrative",
                "elementType": "geometry.fill",
                "stylers": [
                    {
                        "color": "#ffffff"
                    },
                    {
                        "lightness": 20
                    }
                ]
            },
            {
                "featureType": "administrative",
                "elementType": "geometry.stroke",
                "stylers": [
                    {
                        "color": "#fefefe"
                    },
                    {
                        "lightness": 17
                    },
                    {
                        "weight": 1.2
                    }
                ]
            }
        ]; // insert code from https://snazzymaps.com/
        // vars
        var args = {
            zoom: 14,
            scrollwheel: false,
            center: new google.maps.LatLng(0, 0),
            mapTypeId: google.maps.MapTypeId.ROADMAP,
            styles: styles
        };
        var map = new google.maps.Map($el[0], args);
        map.markers = [];
        add_marker($markers, map);

        $(map.markers).each(function () {
            google.maps.event.addListener(this, 'click', function () {
                closeMarkers(map)
                this.infowindow.open(map, this);
            });
        })
        center_map($('.marker'), map);
        // center map on resize
        $(window).on('resize', function () {
            center_map($('.marker'), map);
        });
        onMarkerHover(map);
    }

    function closeMarkers(map) {
        $(map.markers).each(function () {
            this.infowindow.close()
        })
    }

    function add_marker($marker, map) {
        let windows = []
        $marker.each(function () {
            var latlng = new google.maps.LatLng($(this).attr('data-lat'), $(this).attr('data-lng'));

            var $icon = {
                url: $(this).attr('data-icon'),
                //state your size parameters in terms of pixels
                size: new google.maps.Size(50, 50),
                scaledSize: new google.maps.Size(50, 50),
                origin: new google.maps.Point(0, 0)
            }

            var marker = new google.maps.Marker({
                position: latlng,
                map: map,
                icon: $icon,
            });

            marker.infowindow = null
            if ($(this).html()) {
                // create info window
                marker.infowindow = new google.maps.InfoWindow({
                    content: $(this).html()
                });
            }

            map.markers.push(marker);
        })
    }

    function onMarkerHover(map) {
        $('[data-index]').on('mouseenter', function () {
            var index = Number($(this).data('index')) - 1;
            map.markers.map(function (marker, i) {
                if (index === i) {
                    marker.setOptions({
                        animation: google.maps.Animation.BOUNCE
                    });
                }
            })
        })
        $('[data-index]').on('mouseleave', function () {
            var index = Number($(this).data('index')) - 1;
            map.markers.map(function (marker, i) {
                if (index === i) {
                    marker.setOptions({
                        animation: null
                    });
                }
            })
        })
    }



    function center_map($marker, map) {
        // vars
        var bounds = new google.maps.LatLngBounds();
        // loop through all markers and create bounds
        $.each(map.markers, function (i, marker) {
            var latlng = new google.maps.LatLng(marker.position.lat(), marker.position.lng());
            bounds.extend(latlng);
        });
        if (map.markers.length == 1) {
            // set center of map
            map.setCenter(bounds.getCenter());
            map.setZoom(14);
        } else {
            map.fitBounds(bounds);
        }
    }

    render_map($('.map-store'));
})
