<?php
require_once(get_template_directory() . '/functions/init/init-func-plugin-dependencies.php');
require_once(get_template_directory() . '/functions/init/init-func-custom-post-types.php');
require_once(get_template_directory() . '/functions/init/init-func-taxonomies.php');
require_once(get_template_directory() . '/functions/init/init-func-custom-fields.php');
require_once(get_template_directory() . '/functions/init/init-func-widget.php');
require_once(get_template_directory() . '/functions/init/init-func-menu.php');
require_once(get_template_directory() . '/functions/init/init-func-thumbnails.php');
require_once(get_template_directory() . '/functions/init/init-func-enqueue-files.php');

load_theme_textdomain('blanka', get_template_directory() . '/languages');

add_theme_support('automatic-feed-links');
add_theme_support('title-tag');
add_theme_support('html5', array('search-form', 'comment-form', 'comment-list', 'gallery', 'caption'));
//add_theme_support( 'post-formats', array( 'aside', 'image', 'video', 'quote', 'link' ) );

//add custom fonts

add_filter('tiny_mce_before_init', function ($init_array) {
	$style_formats = array(
		// Each array child is a format with it's own settings
		array(
			'title' => 'Image full width',
			'block' => 'div',
			'classes' => 'full-width',
			'wrapper' => true,
		),
		array(
			'title' => 'Image Boxed',
			'block' => 'div',
			'classes' => 'boxed',
			'wrapper' => true,
		),
		array(
			'title' => 'Image Vertical',
			'block' => 'div',
			'classes' => 'vertical',
			'wrapper' => true,
		),
		array(
			'title' => 'Text small',
			'block' => 'span',
			'classes' => 'txt-sm',
			'exact' => true,
			'wrapper' => true,
		),
		array(
			'title' => 'Text medium',
			'block' => 'span',
			'classes' => 'txt-md',
			'exact' => true,
			'wrapper' => true,
		),
		array(
			'title' => 'Text large',
			'block' => 'span',
			'classes' => 'txt-lg',
			'exact' => true,
			'wrapper' => true,
		),
		array(
			'title' => 'Text XL',
			'block' => 'span',
			'classes' => 'txt-xl',
			'exact' => true,
			'wrapper' => true,
		),
		array(
			'title' => 'Text 2XL',
			'block' => 'span',
			'classes' => 'txt-2xl',
			'exact' => true,
			'wrapper' => true,
		),
		array(
			'title' => 'Text 3XL',
			'block' => 'span',
			'classes' => 'txt-3xl',
			'exact' => true,
			'wrapper' => true,
		),
		array(
			'title' => 'Text 4XL',
			'block' => 'span',
			'classes' => 'txt-4xl',
			'exact' => true,
			'wrapper' => true,
		),
		array(
			'title' => 'Text 5XL',
			'block' => 'span',
			'classes' => 'txt-5xl',
			'exact' => true,
			'wrapper' => true,
		),
		array(
			'title' => 'Text 6XL',
			'block' => 'span',
			'classes' => 'txt-6xl',
			'exact' => true,
			'wrapper' => true,
		),
	);
	// Insert the array, JSON ENCODED, into 'style_formats'
	$init_array['style_formats'] = json_encode($style_formats);
	return $init_array;
}, 10, 1);


function lionplugins_woocommerce_checkout_remove_item( $product_name, $cart_item, $cart_item_key ) {
	if ( is_checkout() ) {
		$_product = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
		$product_id = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

		$remove_link = apply_filters( 'woocommerce_cart_item_remove_link', sprintf(
			'<a href="%s" class="remove" aria-label="%s" data-product_id="%s" data-product_sku="%s">×</a>',
			esc_url( WC()->cart->get_remove_url( $cart_item_key ) ),
			__( 'Remove this item', 'woocommerce' ),
			esc_attr( $product_id ),
			esc_attr( $_product->get_sku() )
        ), $cart_item_key );

		return '<span>' . $remove_link . '</span> <span>' . $product_name . '</span>';
	}

	return $product_name;
}
add_filter( 'woocommerce_cart_item_name', 'lionplugins_woocommerce_checkout_remove_item', 10, 3 );


// wp_enqueue_script( 'ajax-load-more.js', get_template_directory_uri().'/js/main/ajax-load-more.js', array( 'jquery'  ) );
// wp_localize_script( 'ajax-load-more.js', 'ajax_object', array('ajax_url' => admin_url('admin-ajax.php')) );
