<?php if(has_post_thumbnail()):
  $thumb = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'medium' );
  $image_url = $thumb['0'];
else:
  $video = get_field('url_video');
  $image_url = $video->thumbnail_url;
endif;
?>
<article class="video-teaser-standard">
  <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
    <figure>
      <img src="<?php echo $image_url; ?>" class="img-responsive" />
    </figure>
  </a>
  <header>
    <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
      <h1><?php the_title(); ?></h1>
    </a>
  </header>
</article>