<?php

/**
 * Shipping Methods Display
 *
 * In 2.1 we show methods per package. This allows for multiple methods per order if so desired.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart-shipping.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.2.0
 */
if (!defined('ABSPATH')) {
	exit;
}
?>
<tr class="shipping">
	<th><?php echo wp_kses_post($package_name); ?></th>
	<td data-title="<?php echo esc_attr($package_name); ?>">
		<?php if (1 < count($available_methods)) : ?>
			<div id="wc-local-pickup-plus-toggle-default-handling">
				<ul id="shipping_method">
				</ul>
			</div>
		<?php elseif (1 === count($available_methods)) :  ?>
			<?php
			$method = current($available_methods);
			printf('%3$s <input type="hidden" name="shipping_method[%1$d]" data-index="%1$d" id="shipping_method_%1$d" value="%2$s" class="shipping_method" />', $index, esc_attr($method->id), wc_cart_totals_shipping_method_label($method));
			$delivery_zones = WC_Shipping_Zones::get_zones();

			//define the array outside of the loop
			$shipping_costs = [];
			$min_zone = "";

			//get all costs in a loop and store them in the array
			foreach ((array) $delivery_zones as $key => $the_zone) {

				foreach ($the_zone['shipping_methods'] as $value) {
					$shipping_costs[] = $value->cost;
				}
			}

			// $content = '<strong>' . $shipping_costs[0] . '€ </strong>';
			// var_dump($index);
			// echo '<div class="shipping-handler" id="wc-local-pickup-plus-toggle-default-handling">';
			// if($cache == 0) {
			// 	echo '<div><a class="toggle-default-handling ship"><div class="checkbox-shipping is-checked"></div></a> Spedizione ' . $content . '</div>';
			// 	echo '<div><a class="toggle-default-handling pickup"><div class="checkbox-shipping"></div></a> Ritiro in sede</div>';
			// } else {
			// 	echo '<div><a class="toggle-default-handling ship"><div class="checkbox-shipping "></div></a> Spedizione ' . $content . '</div>';
			// 	echo '<div><a class="toggle-default-handling pickup"><div class="checkbox-shipping is-checked"></div></a> Ritiro in sede</div>';
			// }
			// echo '</div>';

			
			do_action('woocommerce_after_shipping_rate', $method, $index);
			?>
		<?php elseif (WC()->customer->has_calculated_shipping()) : ?>
			<?php
			if (is_cart()) {
				echo apply_filters('woocommerce_cart_no_shipping_available_html', wpautop(__('There are no shipping methods available. Please ensure that your address has been entered correctly, or contact us if you need any help.', 'woocommerce')));
			} else {
				echo apply_filters('woocommerce_no_shipping_available_html', wpautop(__('There are no shipping methods available. Please ensure that your address has been entered correctly, or contact us if you need any help.', 'woocommerce')));
			}
			?>
		<?php elseif (!is_cart()) : ?>
			<?php echo wpautop(__('Enter your full address to see shipping costs.', 'woocommerce')); ?>
		<?php endif; ?>

		<small class="delivery-notes"><?php _e('Deliveries take up 3 to 5 working days after we confirm your order: our shipment insurance covers the full value of your goods.','blanka');?></small>

		<?php if ($show_package_details) : ?>
			<?php echo '<p class="woocommerce-shipping-contents"><small>' . esc_html($package_details) . '</small></p>'; ?>
		<?php endif; ?>

		<?php if (!empty($show_shipping_calculator)) : ?>
			<?php woocommerce_shipping_calculator(); ?>
		<?php endif; ?>
	</td>
</tr>