<?php
/**
 * My Account Dashboard
 *
 * Shows the first intro screen on the account dashboard.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/dashboard.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @author      WooThemes
 * @package     WooCommerce/Templates
 * @version     2.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
$user = wp_get_current_user();
?>

<!-- USER GENERAL INFOS -->
<h3 class="personal-area-title">
	<?php _e('Informazioni Account','blanka');?>
</h3>
<ul class="main-user-infos">
	<?php if($user->first_name):?>
		<li>
			<label for="account_first_name"><?php _e( 'Nome:', 'blanka' ); ?></label>
			<p type="text" id="account_first_name"><?php echo esc_attr( $user->first_name ); ?></p>
		</li>
	<?php endif;?>
	<?php if($user->last_name):?>
		<li>
			<label for="account_last_name"><?php _e( 'Cognome:', 'blanka' ); ?></label>
			<p type="text" id="account_last_name"><?php echo esc_attr( $user->last_name ); ?></p>
		</li>
	<?php endif;?>
	<?php if($user->user_email):?>
		<li>
			<label for="account_email"><?php _e( 'Indirizzo e-mail:', 'blanka' ); ?></label>
			<p type="text" id="account_email"><?php echo esc_attr( $user->user_email ); ?></p>
		</li>
	<?php endif;?>
	<?php if($user->user_pass):?>
		<li>
			<label for="account_pwd"><?php _e( 'Password:', 'blanka' ); ?></label>
			<input disabled type="password" id="account_pwd" name="<?php echo esc_attr( $user->user_pass ); ?>" value="<?php echo esc_attr( $user->user_pass ); ?>">
		</li>
	<?php endif;?>
</ul>
<?php echo '<a class="custom-underline lined-up" href="'.wc_customer_edit_account_url().'">'. __('Modifica','blanka') .'</a>';?>

<!-- USER ADDRESSES -->
<?php
$customer_id = get_current_user_id();

if ( ! wc_ship_to_billing_address_only() && wc_shipping_enabled() ) {
	$get_addresses = apply_filters( 'woocommerce_my_account_get_addresses', array(
		'shipping' => __( 'Indirizzo di spedizione', 'blanka' ),
		'billing' => __( 'Indirizzo di fatturazione', 'blanka' ),
	), $customer_id );
} else {
	$get_addresses = apply_filters( 'woocommerce_my_account_get_addresses', array(
		'billing' => __( 'Indirizzo di fatturazione', 'woocommerce' ),
	), $customer_id );
}

$oldcol = 1;
$col    = 1;
?>


<?php if ( ! wc_ship_to_billing_address_only() && wc_shipping_enabled() ) : ?>
	<div class="u-columns woocommerce-Addresses col2-set addresses">
<?php endif; ?>

<?php foreach ( $get_addresses as $name => $title ) : ?>

	<div class="u-column<?php echo ( ( $col = $col * -1 ) < 0 ) ? 1 : 2; ?> col-<?php echo ( ( $oldcol = $oldcol * -1 ) < 0 ) ? 1 : 2; ?> woocommerce-Address">
		<h3 class="personal-area-title"><?php echo $title; ?></h3>
		<address><?php
			$address = wc_get_account_formatted_address( $name );
			echo $address ? wp_kses_post( $address ) : esc_html_e( 'You have not set up this type of address yet.', 'woocommerce' );
		?></address>
		<a href="<?php echo esc_url( wc_get_endpoint_url( 'edit-address', $name ) ); ?>" class="custom-underline lined-up"><?php _e( 'Modifica', 'blanka' ); ?></a>
	</div>

<?php endforeach; ?>

<?php if ( ! wc_ship_to_billing_address_only() && wc_shipping_enabled() ) : ?>
	</div>
<?php endif;?>

<!-- <p> -->
	<?php
	// printf(
	// 	__( 'Hello %1$s (not %1$s? <a href="%2$s">Log out</a>)', 'woocommerce' ),
	// 	'<strong>' . esc_html( $current_user->display_name ) . '</strong>',
	// 	esc_url( wc_logout_url( wc_get_page_permalink( 'myaccount' ) ) )
	// );
?>
<!-- </p> -->

<!-- <p> -->
	<?php
	// printf(
	// 	__( 'From your account dashboard you can view your <a href="%1$s">recent orders</a>, manage your <a href="%2$s">shipping and billing addresses</a>, and <a href="%3$s">edit your password and account details</a>.', 'woocommerce' ),
	// 	esc_url( wc_get_endpoint_url( 'orders' ) ),
	// 	esc_url( wc_get_endpoint_url( 'edit-address' ) ),
	// 	esc_url( wc_get_endpoint_url( 'edit-account' ) )
	// );
?>
<!-- </p> -->

<?php
	/**
	 * My Account dashboard.
	 *
	 * @since 2.6.0
	 */
	// do_action( 'woocommerce_account_dashboard' );

	/**
	 * Deprecated woocommerce_before_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	// do_action( 'woocommerce_before_my_account' );

	/**
	 * Deprecated woocommerce_after_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	// do_action( 'woocommerce_after_my_account' );

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
