<?php

/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <main id="main">
 *
 * @author Dueper Design
 * @package Dueper Theme
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
  <meta charset="utf-8">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta charset="<?php bloginfo('charset'); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=0">
  <?php if (!in_array('wordpress-seo/wp-seo.php', apply_filters('active_plugins', get_option('active_plugins')))) : ?>
    <title><?php wp_title('&raquo;', true, 'right'); ?></title>
  <?php endif; ?>
  <link async rel="profile" href="http://gmpg.org/xfn/11">
  <link async rel="pingback" href="<?php bloginfo('pingback_url'); ?>">

  <?php /* --- Gestisci i meta di per i social con il plugin Yoast SEO --- */ ?>

  <?php wp_head(); ?>

  <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->

  <?php if (function_exists('get_field')) echo wp_kses_post(get_field('google_analytics', 'option')); ?>
</head>




<body <?php body_class(); ?>>
  <?php wp_body_open(); ?>
  <div class="shadow"></div>
  <?php get_template_part('inc/preloader/_preloader'); ?>

  <div id="main-container">
    <div class="inner--main">
      <?php
      $preheader_message = get_field('preheader_message', 'option');
      ?>

      <?php if ($preheader_message) : ?>
        <div class="pre-header">
          <?= $preheader_message ?>
        </div>
      <?php endif; ?>

      <?php get_template_part('inc/header/_header', 'main');

      //add hook after header for attach slider, ecc..
      do_action('dueper_after_top_nav'); ?>