<?php
$categories = get_categories( array(
    'orderby' => 'name',
    'order'   => 'ASC'
) );?>

<div class="menu-container">
  <ul class="category-list">
  <?php foreach( $categories as $category ) : ?>
    <?php $category_link = sprintf(
      '<li><a class="custom-underline" href="%1$s" alt="%2$s">%3$s</a></li>',
      esc_url( get_category_link( $category->term_id ) ),
      esc_attr( sprintf( __( 'View all posts in %s', 'textdomain' ), $category->name ) ),
      esc_html( $category->name )
    );
    echo $category_link; ?>
  <?php endforeach; ?>
  </ul>
</div>
