(($) => {
  // --DOCUMENT on ready
  $(document).ready(() => {
    // * HOME SLIDER *
    $('.home-slider .slides').slick({
      dots: false,
      arrows: false,
      infinite: true,
      speed: 1000,
      slidesToShow: 1,
      slidesToScroll: 1,
      fade: true,
      autoplay: true,
      autoplaySpeed: 5000,
      responsive: [
        {
          breakpoint: 1024,
          settings: {

          }
        },
        // You can unslick at a given breakpoint now by adding:
        // settings: "unslick"
        // instead of a settings object
      ]
    })
    // * PRODUCTs SLIDER *
    $('.product-slides').slick({
      dots: false,
      arrows: true,
      infinite: true,
      speed: 300,
      slidesToShow: 4,
      slidesToScroll: 4,
      responsive: [
        {
          breakpoint: 1024,
          settings: {
            slidesToShow: 3,
            slidesToScroll: 3,
            infinite: true,
            arrows: false
          }
        },
        {
          breakpoint: 768,
          settings: {
            slidesToShow: 2,
            slidesToScroll: 2
          }
        },
        {
          breakpoint: 500,
          settings: {
            slidesToShow: 1,
            slidesToScroll: 1
          }
        },
        // You can unslick at a given breakpoint now by adding:
        // settings: "unslick"
        // instead of a settings object
      ]
    })
    $('.product-slides .slide').on('mouseenter', function fadeEl() {
      const $this = $(this)
      $('.product-slides .slide').addClass('faded')
      $this.removeClass('faded')
    })
    $('.product-slides .slide').on('mouseleave', () => {
      $('.product-slides .slide').removeClass('faded')
    })

    // * FORM CREAZIONE *
    $('.form-creazione').slick({
      dots: false,
      arrows: false,
      infinite: false,
      speed: 500,
      slidesToShow: 1,
      slidesToScroll: 1,
      swipe: false
    })
    $('.form-creazione').on('beforeChange', () => {
      $('.form-header li').removeClass('current-step')
    })
    $('.form-creazione').on('afterChange', (slick, currentSlide) => {
      const current = $('.form-creazione').slick('slickCurrentSlide')
      const step = $(`.form-header ul li[data-step="${current + 1}"]`)
      step.addClass('current-step')
    })
    $('.next-step').click(function nextStep(e) {
      e.preventDefault()
      $(this).parents('.slick-slider').slick('slickNext')
    })
    $('.title-expandable').click(function closeNext(e) {
      e.preventDefault()
      $(this).toggleClass('closed')
      $(this).next('.collapsable-text').slideToggle()
    })

    // * SINGLE PRODUCT SLIDER *
    $('.big-slider .woocommerce-product-gallery__wrapper').slick({
      dots: true,
      arrows: true,
      infinite: true,
      speed: 300,
      fade: true,
      // adaptiveHeight: true,
      slidesToShow: 1,
      slidesToScroll: 1,
      asNavFor: '.small-slider .woocommerce-product-gallery__wrapper',
      responsive: [
        {
          breakpoint: 768,
          settings: {
            slidesToShow: 1,
            infinite: true,
            // dots: true
          }
        },
        // {
        //   breakpoint: 600,
        //   settings: {
        //     slidesToShow: 2,
        //     slidesToScroll: 2
        //   }
        // },
        // {
        //   breakpoint: 480,
        //   settings: {
        //     slidesToShow: 1,
        //     slidesToScroll: 1
        //   }
        // }
        // You can unslick at a given breakpoint now by adding:
        // settings: "unslick"
        // instead of a settings object
      ],
    })
    $('.small-slider .woocommerce-product-gallery__wrapper').slick({
      dots: false,
      arrows: true,
      infinite: true,
      speed: 300,
      slidesToShow: 3,
      slidesToScroll: 3,
      centerMode: true,
      asNavFor: '.big-slider .woocommerce-product-gallery__wrapper',
      responsive: [
        {
          breakpoint: 1024,
          settings: {
            slidesToShow: 2,
            slidesToScroll: 1,
            infinite: true,
            // dots: true
          }
        },
        // {
        //   breakpoint: 600,
        //   settings: {
        //     slidesToShow: 2,
        //     slidesToScroll: 2
        //   }
        // },
        // {
        //   breakpoint: 480,
        //   settings: {
        //     slidesToShow: 1,
        //     slidesToScroll: 1
        //   }
        // }
        // You can unslick at a given breakpoint now by adding:
        // settings: "unslick"
        // instead of a settings object
      ]
    })
    $('.small-slider .woocommerce-product-gallery__wrapper .slick-slide').click(function () {
      const $this = $(this)
      const data = $this.data('slick-index')
      $this.parents('.woocommerce-product-gallery__wrapper').slick('slickGoTo', data, false)
    })
  })
})(jQuery)
