<?php
if( !function_exists('get_social_share') ){
  /* More info to csbutton.js to http://acrow.fr/csbuttons/ */
  function get_social_share( $args = array(
    'type' => null,
    'url',
    'txt',
    'via',
    'count' => false,
    'count_position' => 'right',
    'total_count' => null
  ) ){
    global $post;

    if($args['type']){
      $type = $args['type'];
    } else {
      $type = array('facebook', 'twitter', 'google', 'whatsapp', 'pinterest');
    }
    if(empty($args['url'])){
      $args['url'] = get_permalink($post->ID);
    }
    if(empty($args['txt'])){
      $args['txt'] = $post->post_title;
    }
    $output = '<ul class="social-share">';
    foreach($type as $social){
      $output .= '<li class="'.$social.'-wrapper">';
      if($social === 'whatsapp') {
        $output .= '<a href="javascript:void(0)" data-url="'.$args['url'].'" class="whatsapp-share">';
        $output .= '<i class="icon-whatsapp"></i>';
        $output .= '</a>';

      } else {
        $output .= '<a href="javascript:void(0)" class="csbuttons '.$social.'" ';
        $output .= ' data-url="'.$args['url'].'" ';
        $output .= ' data-type="'.$social.'" ';
        $output .= ' data-txt="'.strip_tags($args['txt']).'" ';
        if(!empty($args['via'])) $output .= ' data-via="'.$args['via'].'" ';
        if(!empty($args['count'])) $output .= ' data-count="'.$args['count'].'" ';
        if(!empty($args['count_position'])) $output .= ' data-count-position="'.$args['count_position'].'" ';
        $output .= '><i class="icon-'.$social.'"></i>';
        $output .= '</a>';
      }
      $output .= '</li>';
    }
    $output .= '</ul>';

    print $output;
  }
}
