<?php if( have_rows('prod_slider') ): ?>
<section class="home-section home-products">
	<h3 class="section-title"><?php _e('Scopri i nostri prodotti','blanka');?></h3>
	<ul class="product-slides">
	<?php while( have_rows('prod_slider') ): the_row();
		// vars
		$prod = get_sub_field('product');
    // override $post
  	$post = $prod;
  	setup_postdata( $post );
		?>

		<?php if($post):?>
		<li class="slide">
			<?php
			$image['placeholder'] = get_the_post_thumbnail_url(get_the_ID(), 'placeholder');
			$image['default'] = get_the_post_thumbnail_url(get_the_ID(), 'large');
			$image['retina'] = get_the_post_thumbnail_url(get_the_ID(), 'large');
			$_ID = get_the_ID();
			if($_ID) {
				$_product = wc_get_product($_ID);
				$brand_title = $_product->get_attribute('brand');
				$price = wc_price($_product->get_regular_price());
				$price_on_sale = wc_price($_product->get_sale_price());
			}

			?>

			<article <?php post_class('product-teaser'); ?>>
			  <figure class="">
			    <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
			      <img class="lazy-blanka img-responsive" src="<?= $image['retina'] ?>" data-src="<?= $image['default'] ?>" data-src-retina="<?= $image['retina'] ?>"
						alt="<?= get_the_title() ?>" title="<?= get_the_title() ?>" longdesc="<?= get_the_title() ?>"/>
			    </a>
			  </figure>
			  <div class="content">
			    <header>
			      <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
							<h4 class="brand-title">
			        	<?php if($brand_title) echo $brand_title;?>
							</h4>
			        <h3 class="product-title"><?php the_title(); ?></h3>
			      </a>
			    </header>
			    <?php if($_product->is_on_sale()):
			      echo '<label class="original-price override">€ '.$price.'</label>';
			      echo '<label class="sale-price">€ '.$price_on_sale.'</label>';
			    else:
			      echo '<label class="original-price">€ '.$price.'</label>';
			    endif; ?>
			  </div>
			  <div class="clearfix"></div>
			</article><!--post-class-->

			<?php if( function_exists('the_blogpost_json_ld') ):
			  the_blogpost_json_ld($post->ID);
			endif; ?>
		</li>
		<?php endif; ?>
    <?php wp_reset_postdata();?>
	<?php endwhile; ?>
	</ul>
</section>
<?php endif; ?>
