<?php
/**
 * The template for displaying Archive pages.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @author Dueper Design
 * @package Dueper Theme
 */

get_header(); ?>
<header>
    <div class="container">
      <h1 class="page-title">
        <?php
          if ( is_category() ) :
              single_cat_title();

          elseif ( is_post_type_archive() ) :
              post_type_archive_title();

          elseif ( is_tag() ) :
              single_tag_title();

          elseif ( is_author() ) :
              /* Queue the first post, that way we know
               * what author we're dealing with (if that is the case).
              */
              the_post();
              printf( __( 'Author: %s', 'blanka' ), '<span class="vcard">' . get_the_author_meta('display_name') . '</span>' );
              /* Since we called the_post() above, we need to
               * rewind the loop back to the beginning that way
               * we can run the loop properly, in full.
               */
              rewind_posts();

          elseif ( is_day() ) :
              printf( __( 'Day: %s', 'blanka' ), '<span>' . get_the_date() . '</span>' );

          elseif ( is_month() ) :
              printf( __( 'Month: %s', 'blanka' ), '<span>' . get_the_date( 'F Y' ) . '</span>' );

          elseif ( is_year() ) :
              printf( __( 'Year: %s', 'blanka' ), '<span>' . get_the_date( 'Y' ) . '</span>' );

          elseif ( is_tax( 'post_format', 'post-format-aside' ) ) :
              _e( 'Asides', 'blanka' );

          elseif ( is_tax( 'post_format', 'post-format-image' ) ) :
              _e( 'Images', 'blanka');

          elseif ( is_tax( 'post_format', 'post-format-video' ) ) :
              _e( 'Videos', 'blanka' );

          elseif ( is_tax( 'post_format', 'post-format-quote' ) ) :
              _e( 'Quotes', 'blanka' );

          elseif ( is_tax( 'post_format', 'post-format-link' ) ) :
              _e( 'Links', 'blanka' );

          else :
              _e( 'Archives', 'blanka' );

          endif;
      ?>
      </h1>
    </div><!--container-->
</header><!-- .page-header -->
<div class="container">
  <div class="row">
    <div class="col-md-8">
      <?php if ( have_posts() ) :
        while ( have_posts() ) : the_post();
          get_template_part('inc/teaser/_teaser', 'post');
        endwhile;
      endif; ?>
      <?php if(function_exists('wp_pagenavi')):
        wp_pagenavi();
      endif;?>
    </div><!--col-md-8-->
    <div class="col-md-4">
      <?php get_sidebar(); ?>
    </div><!--col-md-4-->
  </div><!--row-->
</div><!--container-->
<?php get_footer(); ?>
